/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.cff;

import java.io.DataInput;
import java.io.IOException;

public class Index {
    private final int _count;
    private final int _offSize;
    private final int[] _offset;
    private final int[] _data;

    public Index(DataInput dataInput) throws IOException {
        int n;
        this._count = dataInput.readUnsignedShort();
        this._offset = new int[this._count + 1];
        this._offSize = dataInput.readUnsignedByte();
        for (n = 0; n < this._count + 1; ++n) {
            int n2 = 0;
            for (int i = 0; i < this._offSize; ++i) {
                n2 |= dataInput.readUnsignedByte() << (this._offSize - i - 1) * 8;
            }
            this._offset[n] = n2;
        }
        this._data = new int[this.getDataLength()];
        for (n = 0; n < this.getDataLength(); ++n) {
            this._data[n] = dataInput.readUnsignedByte();
        }
    }

    public final int getCount() {
        return this._count;
    }

    public final int getOffset(int n) {
        return this._offset[n];
    }

    public final int getDataLength() {
        return this._offset[this._offset.length - 1] - 1;
    }

    public final int[] getData() {
        return this._data;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DICT\n");
        stringBuilder.append("count: ").append(this._count).append("\n");
        stringBuilder.append("offSize: ").append(this._offSize).append("\n");
        for (n = 0; n < this._count + 1; ++n) {
            stringBuilder.append("offset[").append(n).append("]: ").append(this._offset[n]).append("\n");
        }
        stringBuilder.append("data:");
        for (n = 0; n < this._data.length; ++n) {
            if (n % 8 == 0) {
                stringBuilder.append("\n");
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this._data[n]);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

