/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.lang.ref.WeakReference;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.swing.text.AttributeSet;
import org.GNOME.Accessibility.AtkText;
import org.GNOME.Accessibility.AtkUtil;

public class AtkEditableText
extends AtkText {
    WeakReference<AccessibleEditableText> _acc_edt_text;

    public AtkEditableText(AccessibleContext accessibleContext) {
        super(accessibleContext);
        this._acc_edt_text = new WeakReference<AccessibleEditableText>(accessibleContext.getAccessibleEditableText());
    }

    public static AtkEditableText createAtkEditableText(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> new AtkEditableText(accessibleContext), null);
    }

    public void set_text_contents(String string) {
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return;
        }
        AtkUtil.invokeInSwing(() -> accessibleEditableText.setTextContents(string));
    }

    public void insert_text(String string, int n) {
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = n;
        AtkUtil.invokeInSwing(() -> accessibleEditableText.insertTextAtIndex(n2, string));
    }

    public void copy_text(int n, int n2) {
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return;
        }
        int n3 = accessibleEditableText.getCharCount();
        if (n < 0) {
            n = 0;
        }
        if (n2 > n3 || n2 == -1) {
            n2 = n3;
        } else if (n2 < -1) {
            n2 = 0;
        }
        int n4 = n;
        int n5 = n2;
        AtkUtil.invokeInSwing(() -> {
            String string = accessibleEditableText.getTextRange(n4, n5);
            if (string != null) {
                StringSelection stringSelection = new StringSelection(string);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        });
    }

    public void cut_text(int n, int n2) {
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return;
        }
        AtkUtil.invokeInSwing(() -> accessibleEditableText.cut(n, n2));
    }

    public void delete_text(int n, int n2) {
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return;
        }
        AtkUtil.invokeInSwing(() -> accessibleEditableText.delete(n, n2));
    }

    public void paste_text(int n) {
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return;
        }
        AtkUtil.invokeInSwing(() -> accessibleEditableText.paste(n));
    }

    public boolean setRunAttributes(AttributeSet attributeSet, int n, int n2) {
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> {
            accessibleEditableText.setAttributes(n, n2, attributeSet);
            return true;
        }, false);
    }
}

