/*
 * Decompiled with CFR 0.152.
 */
package org.jpeg.jpegxl.wrapper;

import java.nio.Buffer;
import org.jpeg.jpegxl.wrapper.PixelFormat;
import org.jpeg.jpegxl.wrapper.Status;
import org.jpeg.jpegxl.wrapper.StreamInfo;

class DecoderJni {
    private static native void nativeGetBasicInfo(int[] var0, Buffer var1);

    private static native void nativeGetPixels(int[] var0, Buffer var1, Buffer var2, Buffer var3);

    static Status makeStatus(int n) {
        switch (n) {
            case 0: {
                return Status.OK;
            }
            case -1: {
                return Status.INVALID_STREAM;
            }
            case 1: {
                return Status.NOT_ENOUGH_INPUT;
            }
        }
        throw new IllegalStateException("Unknown status code");
    }

    static StreamInfo makeStreamInfo(int[] nArray) {
        StreamInfo streamInfo = new StreamInfo();
        streamInfo.status = DecoderJni.makeStatus(nArray[0]);
        streamInfo.width = nArray[1];
        streamInfo.height = nArray[2];
        streamInfo.pixelsSize = nArray[3];
        streamInfo.iccSize = nArray[4];
        streamInfo.alphaBits = nArray[5];
        return streamInfo;
    }

    static StreamInfo getBasicInfo(Buffer buffer, PixelFormat pixelFormat) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("data must be direct buffer");
        }
        int[] nArray = new int[6];
        nArray[0] = pixelFormat == null ? -1 : pixelFormat.ordinal();
        DecoderJni.nativeGetBasicInfo(nArray, buffer);
        return DecoderJni.makeStreamInfo(nArray);
    }

    static Status getPixels(Buffer buffer, Buffer buffer2, Buffer buffer3, PixelFormat pixelFormat) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("data must be direct buffer");
        }
        if (!buffer2.isDirect()) {
            throw new IllegalArgumentException("pixels must be direct buffer");
        }
        if (!buffer3.isDirect()) {
            throw new IllegalArgumentException("icc must be direct buffer");
        }
        int[] nArray = new int[]{pixelFormat.ordinal()};
        DecoderJni.nativeGetPixels(nArray, buffer, buffer2, buffer3);
        return DecoderJni.makeStatus(nArray[0]);
    }

    private DecoderJni() {
    }
}

