/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.remote.metadata.client.DataObjectRequest;
import org.opensearch.remote.metadata.client.WriteDataObjectRequest;

public class BulkDataObjectRequest {
    private final List<DataObjectRequest> requests = new ArrayList<DataObjectRequest>();
    private final Set<String> indices = new HashSet<String>();
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
    private TimeValue timeout = TimeValue.timeValueMinutes((long)1L);
    private String globalIndex;

    public BulkDataObjectRequest(@Nullable String globalIndex) {
        this.globalIndex = globalIndex;
    }

    public List<DataObjectRequest> requests() {
        return List.copyOf(this.requests);
    }

    public Set<String> getIndices() {
        return Collections.unmodifiableSet(this.indices);
    }

    @Deprecated(since="3.3.0", forRemoval=true)
    public BulkDataObjectRequest add(DataObjectRequest request) {
        throw new IllegalArgumentException("No support for request [" + request.getClass().getName() + "]");
    }

    public <R extends WriteDataObjectRequest<R>> BulkDataObjectRequest add(R request) {
        if (Strings.isNullOrEmpty((String)request.index())) {
            if (Strings.isNullOrEmpty((String)this.globalIndex)) {
                throw new IllegalArgumentException("Either the request [" + request.getClass().getName() + "] or the bulk request must specify an index.");
            }
            this.indices.add(this.globalIndex);
            request.index(this.globalIndex);
        } else {
            this.indices.add(request.index());
        }
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
        this.requests.add(request);
        return this;
    }

    public BulkDataObjectRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public final BulkDataObjectRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public final BulkDataObjectRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout")));
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String globalIndex = null;

        protected Builder() {
        }

        public Builder globalIndex(String index) {
            this.globalIndex = index;
            return this;
        }

        public BulkDataObjectRequest build() {
            return new BulkDataObjectRequest(this.globalIndex);
        }
    }
}

