/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RenewDelegationTokenResponse;

public class RenewDelegationTokenRequest
extends AbstractRequest {
    private final RenewDelegationTokenRequestData data;

    public RenewDelegationTokenRequest(RenewDelegationTokenRequestData data, short version) {
        super(ApiKeys.RENEW_DELEGATION_TOKEN, version);
        this.data = data;
    }

    public static RenewDelegationTokenRequest parse(Readable readable, short version) {
        return new RenewDelegationTokenRequest(new RenewDelegationTokenRequestData(readable, version), version);
    }

    @Override
    public RenewDelegationTokenRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new RenewDelegationTokenResponse(new RenewDelegationTokenResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()));
    }

    private static String maskData(RenewDelegationTokenRequestData data) {
        RenewDelegationTokenRequestData tempData = data.duplicate();
        tempData.setHmac(new byte[0]);
        return tempData.toString();
    }

    @Override
    public String toString() {
        return RenewDelegationTokenRequest.maskData(this.data);
    }

    public static class Builder
    extends AbstractRequest.Builder<RenewDelegationTokenRequest> {
        private final RenewDelegationTokenRequestData data;

        public Builder(RenewDelegationTokenRequestData data) {
            super(ApiKeys.RENEW_DELEGATION_TOKEN);
            this.data = data;
        }

        @Override
        public RenewDelegationTokenRequest build(short version) {
            return new RenewDelegationTokenRequest(this.data, version);
        }

        public String toString() {
            return RenewDelegationTokenRequest.maskData(this.data);
        }
    }
}

