#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 tyzef <stefan@tyzef.infini.fr>
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# FlatOut
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250709.5

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='flatout-1'
GAME_NAME='FlatOut'

ARCHIVE_BASE_1_NAME='flatout_gog_3_23461.sh'
ARCHIVE_BASE_1_MD5='a9e80bca460e8c09c5d5e2242564bd8f'
ARCHIVE_BASE_1_SIZE='2298217'
ARCHIVE_BASE_1_VERSION='1.0-gog23461'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/flatout'

CONTENT_PATH_DEFAULT='data/noarch/prefix/drive_c/GOG Games/FlatOut'
CONTENT_GAME_BIN_FILES='
paul.dll
flatout.exe
*.dll'
CONTENT_GAME_DATA_FILES='
data'

USER_PERSISTENT_DIRECTORIES='
Savegame'

APP_MAIN_EXE='flatout.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## Easier upgrades from pre-20250709.4 packages.
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
flatout"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20250709.4 packages.
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
flatout-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
