//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpolicyinsights

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAttestationsClient creates a new instance of AttestationsClient.
func (c *ClientFactory) NewAttestationsClient() *AttestationsClient {
	subClient, _ := NewAttestationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPolicyEventsClient creates a new instance of PolicyEventsClient.
func (c *ClientFactory) NewPolicyEventsClient() *PolicyEventsClient {
	subClient, _ := NewPolicyEventsClient(c.credential, c.options)
	return subClient
}

// NewPolicyMetadataClient creates a new instance of PolicyMetadataClient.
func (c *ClientFactory) NewPolicyMetadataClient() *PolicyMetadataClient {
	subClient, _ := NewPolicyMetadataClient(c.credential, c.options)
	return subClient
}

// NewPolicyRestrictionsClient creates a new instance of PolicyRestrictionsClient.
func (c *ClientFactory) NewPolicyRestrictionsClient() *PolicyRestrictionsClient {
	subClient, _ := NewPolicyRestrictionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPolicyStatesClient creates a new instance of PolicyStatesClient.
func (c *ClientFactory) NewPolicyStatesClient() *PolicyStatesClient {
	subClient, _ := NewPolicyStatesClient(c.credential, c.options)
	return subClient
}

// NewPolicyTrackedResourcesClient creates a new instance of PolicyTrackedResourcesClient.
func (c *ClientFactory) NewPolicyTrackedResourcesClient() *PolicyTrackedResourcesClient {
	subClient, _ := NewPolicyTrackedResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRemediationsClient creates a new instance of RemediationsClient.
func (c *ClientFactory) NewRemediationsClient() *RemediationsClient {
	subClient, _ := NewRemediationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
