<!--
    SPDX-FileCopyrightText: Copyright 2024-2025 Arm Limited and/or its affiliates <open-source-office@arm.com>

    SPDX-License-Identifier: Apache-2.0
-->

# KleidiAI documentation and guides

Welcome to the KleidiAI documentation hub. Here, you will find a variety of step-by-step guides to help you master this library. For instance, you can explore introductory tutorials on running a micro-kernel and discover best practices for optimizing the performance of your AI framework on Arm® CPUs.

## Table of Contents

### Guides

- [How to run the int4 matmul micro-kernels](matmul_qsi4cx/README.md)
- [How to run the indirect matmul micro-kernels](imatmul/README.md)
- [KleidiAI micro-kernel overview](../kai/ukernels/matmul/README.md)
- [Packing micro-kernels description](../kai/ukernels/matmul/pack/README.md)
- [Integrating KleidiAI into MLAS via MlasGemmBatch](framework_integration_examples/kleidiai_mlas_integration.md)
- [Integrating KleidiAI Int4 matrix multiplication micro-kernel into llama.cpp](https://github.com/Arm-Examples/ML-examples/blob/main/kleidiai-examples/llama_cpp/0001-Use-KleidiAI-Int4-Matmul-micro-kernels-in-llama.cpp.patch)
