[Setup]
AppName=MineXpert3

; Set version number below
#define public version "10.0.0"
AppVersion={#version}

#define public arch "mingw64"
#define public platform "win10"
#define public buildsystem "MXE"

;;;;;; On Wine, z: drive is configured to point to /home/rusconi
;;;;;; Check the winecfg window's Drives tab

#define sourceDir "z:/devel/minexpert3/development"

#define buildDir "z:/devel/minexpert3/build-area/mxe"

#define buildDocDir "z:/devel/minexpert3/build-area/unix/doc/user-manual"

#define mxeDllDir "z:/devel/mxe/dlls-and-stuff-for-packages"


; Set version number below
AppVerName=MineXpert3 version {#version}
DefaultDirName={commonpf}\MineXpert3
DefaultGroupName=MineXpert3
OutputDir="{#sourceDir}\winInstaller"

OutputBaseFilename=MineXpert3-{#arch}-{#platform}-{#buildsystem}-v{#version}-setup

OutputManifestFile=MineXpert3-{#arch}-{#platform}-{#buildsystem}-v{#version}-setup-manifest.txt
ArchitecturesAllowed=x64
ArchitecturesInstallIn64BitMode=x64

LicenseFile="{#sourceDir}/LICENSE"
AppCopyright="Copyright (C) 2009-2025 Filippo Rusconi"

AllowNoIcons=yes
AlwaysShowComponentsList=yes
AllowRootDirectory=no
AllowCancelDuringInstall=yes
AppComments=MineXpert3, by Filippo Rusconi"
AppContact="Filippo Rusconi, PhD, Research scientist at CNRS, France"
CloseApplications=yes
CreateUninstallRegKey=yes
DirExistsWarning=yes
WindowResizable=yes
WizardImageFile="{#sourceDir}\images\splashscreen-minexpert3-innosetup.bmp"
WizardImageStretch=yes

[Dirs]
Name: "{app}\data"
Name: "{app}\doc"

[Files]
Source: "{#mxeDllDir}/*"; DestDir: {app}; Flags: ignoreversion recursesubdirs;

Source: "{#sourceDir}/doc/history.html"; DestDir: {app}\doc;

Source: "{#buildDir}/src/MineXpert3.exe"; DestDir: {app};
;;;; Source: "{#buildDir}/qml/*"; Flags: recursesubdirs; DestDir: {app}\lib\qml;

Source: "{#buildDocDir}/minexpert3-doc.pdf"; DestDir: {app}\doc;
Source: "{#buildDocDir}/html/user-manual/*"; Flags: recursesubdirs; DestDir: {app}\doc\html;

[Icons]
Name: "{group}\MineXpert3"; Filename: "{app}\MineXpert3.exe"; WorkingDir: "{app}"
Name: "{group}\Uninstall MineXpert3"; Filename: "{uninstallexe}"

[Run]
Filename: "{app}\MineXpert3.exe"; Description: "Launch MineXpert3"; Flags: postinstall nowait unchecked

