# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python put_by_subscription_security_standard_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.security_standards.create_or_update(
        scope="subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
        standard_id="8bb8be0a-6010-4789-812f-e4d661c4ed0e",
        standard={
            "properties": {
                "assessments": [
                    {"assessmentKey": "1195afff-c881-495e-9bc5-1486211ae03f"},
                    {"assessmentKey": "dbd0cb49-b563-45e7-9724-889e799fa648"},
                ],
                "cloudProviders": ["GCP"],
                "description": "description of Azure Test Security Standard 1",
                "displayName": "Azure Test Security Standard 1",
                "policySetDefinitionId": "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Authorization/policySetDefinitions/patchorchestration-applicationversions",
            }
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/stable/2024-08-01/examples/SecurityStandards/PutBySubscriptionSecurityStandard_example.json
if __name__ == "__main__":
    main()
