# Installation

Difftastic can be installed as pre-built binaries or using various package managers.

## Pre-Built Binaries

Difftastic releases are published as [GitHub
releases](https://github.com/Wilfred/difftastic/releases) with
pre-built binaries for Windows, macOS and Linux. Open the [latest
release page](https://github.com/Wilfred/difftastic/releases/latest),
download the file matching your OS and CPU architecture, and extract
the `difft` executable application file.

## Package Manager

### macOS

If you're a **Homebrew** user, you can install
[difftastic](https://formulae.brew.sh/formula/difftastic) with `brew`.

```
$ brew install difftastic
```

### Linux and Unix

If you're an **Arch Linux** user, you can install
[difftastic](https://archlinux.org/packages/extra/x86_64/difftastic/)
with `pacman`.

```
$ sudo pacman -S difftastic
```

If you're a **Nix** user, you can install
[difftastic](https://github.com/NixOS/nixpkgs/blob/master/pkgs/tools/text/difftastic/default.nix)
with `nix-env`.

```
$ nix-env --install difftastic
```

If you're a **Fedora** user, you can install
[difftastic](https://packages.fedoraproject.org/pkgs/rust-difftastic/difftastic/)
with `dnf`.

```
$ sudo dnf install difftastic
```

If you're a **FreeBSD** user, you can install
[difftastic](https://www.freshports.org/textproc/difftastic/)
with `pkg`.

```
$ sudo pkg install difftastic
```

### Windows

If you're a Windows user using **Windows Package Manager** (*WinGet*),
you can install difftastic with `winget`.

```
$ winget install difftastic
```

If you're a Windows user using **Scoop**, you can install
[difftastic](https://scoop.sh/#/apps?q=difftastic)
with `scoop`.

```
$ scoop install difftastic
```

If you're a Windows user using **Chocolatey**, you can install
[difftastic](https://community.chocolatey.org/packages/difftastic)
with `choco`.

```
$ choco install difftastic
```

## Full Package Listing

This table lists all the platforms that have packaged difftastic.

[![Packaging status](https://repology.org/badge/vertical-allrepos/difftastic.svg)](https://repology.org/project/difftastic/versions)

