//
// Syd: rock-solid application kernel
// benches/sys/getpid.rs: getpid microbenchmarks
//
// Copyright (c) 2024, 2025 Ali Polatel <alip@chesswob.org>
// Based in part upon gVisor's getpid_benchmark.cc which is:
//   Copyright 2020 The gVisor Authors.
//   SPDX-License-Identifier: Apache-2.0
//
// SPDX-License-Identifier: GPL-3.0

// A micro-benchmark which replicates the gVisor getpid
// micro-benchmarks, but without inline assembly.  Instead, we directly
// invoke the kernel via a simple `syscall!` macro.

use brunch::{benches, Bench};
use libc::{syscall, SYS_getpid};

/// Benchmark calling the `SYS_getpid` syscall via our macro.
fn bm_getpid() {
    // Just call `syscall!` in a tight loop.
    // SAFETY: getpid(2) never returns error.
    let _ = unsafe { syscall(SYS_getpid) };
}

fn main() {
    benches!(
        inline:

        Bench::new("GetPID").run(|| {
            bm_getpid();
        }),
    );
}
