// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief Cross-sections for light hadrons at 3.773 and 3.650 GeV
  class BESII_2007_I763880 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESII_2007_I763880);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");
      declare(UnstableParticles(), "UFS");

      // Book histograms
      for (size_t ix=4; ix<8; ++ix) {
        book(_nMeson[ix], 1, 1, ix);
      }

      for (const string& en : _nMeson[5].binning().edges<0>()) {
        const double eval = stod(en);
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    void findChildren(const Particle& p, map<long,int>& nRes, int& ncount) const {
      for (const Particle& child : p.children()) {
        if (child.children().empty()) {
          nRes[child.pid()]-=1;
          --ncount;
        }
        else {
          findChildren(child,nRes,ncount);
        }
      }
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      const FinalState& ufs = apply<FinalState>(event, "UFS");
      for (const Particle& p : ufs.particles()) {
        if (p.children().empty()) continue;
        if (p.pid()!=223 && p.pid()!=113 && p.abspid()!=313 && p.abspid()!=323) continue;
        map<long,int> nRes = nCount;
        int ncount = ntotal;
        findChildren(p,nRes,ncount);
        if (p.pid()==113) {
          if (ncount!=3) continue;
          unsigned int npi(0),nK(0);
          bool matched = true;
          for (const auto& val : nRes) {
            if (abs(val.first)==111 && val.second==1) {
              npi += 1;
            }
            else if (abs(val.first)==321 && val.second==1) {
              nK += 1;
            }
            else if (val.second!=0) {
              matched = false;
              break;
            }
          }
          if (matched && npi==1 && nK==2 && _sqs=="3.65") _nMeson[4]->fill(_sqs);
        }
        else if (p.abspid()==213) {
          if (ncount!=3) continue;
          unsigned int npi(0),nK(0);
          bool matched = true;
          int ipi = p.pid()==213 ? -211 : 211;
          for (const auto& val : nRes) {
            if (abs(val.first)== ipi && val.second==1) {
              npi+=1;
            }
            else if (abs(val.first)==321 && val.second==1) {
              nK+=1;
            }
            else if (val.second!=0) {
              matched = false;
              break;
            }
          }
          if (matched && npi==1 && nK==2)  _nMeson[5]->fill(_sqs);
        }
        else if (p.abspid()==313) {
          if (ncount!=3) continue;
          unsigned int npi(0),nK(0),npi0(0);
          bool matched = true;
          int ipi = p.pid()==313 ?  211 : -211;
          int iK  = p.pid()==313 ? -321 :  321;
          for (const auto& val : nRes) {
            if (abs(val.first)== ipi && val.second==1) {
              npi+=1;
            }
            else if (abs(val.first)==iK && val.second==1) {
              nK+=1;
            }
            if (abs(val.first)== 111 && val.second==1) {
              npi0+=1;
            }
            else if (val.second!=0) {
              matched = false;
              break;
            }
          }
          if (matched && npi==1 && nK==1 && npi0==1) {
            _nMeson[6]->fill(_sqs);
          }
        }
        else if (p.abspid()==323) {
          if (ncount!=3) continue;
          unsigned int npi(0),nK(0),npi0(0);
          bool matched = true;
          int ipi = p.pid()==323 ?  211 : -211;
          int iK  = p.pid()==323 ? -321 :  321;
          for (const auto& val : nRes) {
            if (abs(val.first)== ipi && val.second==1) {
              npi+=1;
            }
            else if (abs(val.first)==iK && val.second==1) {
              nK+=1;
            }
            if (abs(val.first)== 111 && val.second==1) {
              npi0+=1;
            }
            else if (val.second!=0) {
              matched = false;
              break;
            }
          }
          if (matched && npi==1 && nK==1 && npi0==1) {
            _nMeson[7]->fill(_sqs);
          }
        }
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_nMeson, crossSection()/ sumOfWeights() /nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    map<int,BinnedHistoPtr<string>> _nMeson;
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESII_2007_I763880);

}
