include(${CMAKE_CURRENT_LIST_DIR}/check-common.cmake)

if(msys1_prefix)
  string(REPLACE "${msys1_prefix}" "" test_shell_path ${test_shell_path})
endif()

if(WIN32)
  if(CMAKE_GENERATOR STREQUAL "MSYS Makefiles")
    check(test_shell_path [[/c/shell/path]])
  elseif(CMAKE_GENERATOR STREQUAL "Unix Makefiles")
    check(test_shell_path [[c:/shell/path]])
  else()
    check(test_shell_path [[c:\shell\path]])
  endif()
else()
  check(test_shell_path [[/shell/path]])
endif()
if(WIN32)
  if(CMAKE_GENERATOR STREQUAL "MSYS Makefiles")
    if(msys1_prefix)
      # The comparison was done at generate time with the STREQUAL genex.
      check(test_shell_path2 [[1]])
    else()
      check(test_shell_path2 [[/c/shell/path:/d/another/path]])
    endif()
  elseif(CMAKE_GENERATOR STREQUAL "Unix Makefiles")
    check(test_shell_path2 [[c:/shell/path;d:/another/path]])
  else()
    check(test_shell_path2 [[c:\shell\path;d:\another\path]])
  endif()
else()
  check(test_shell_path2 [[/shell/path:/another/path]])
endif()

check(if_1 "a")
check(if_2 "b")
check(if_3 "b")
check(if_4 "a")
