/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.toolchain;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.TextFormat;
import io.bazel.kotlin.builder.toolchain.CompilationStatusException;
import io.bazel.kotlin.model.CompilationTaskInfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ-\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0018J'\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0019JN\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b2\u001e\u0010\u001d\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001f\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u001e2\b\b\u0002\u0010 \u001a\u00020\f2\b\b\u0002\u0010!\u001a\u00020\fJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\fJ\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0007J\u0014\u0010'\u001a\u00020#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bJ0\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\u00072\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b2\b\b\u0002\u0010+\u001a\u00020\u00072\b\b\u0002\u0010,\u001a\u00020\fJ\u0016\u0010-\u001a\u00020#2\u0006\u0010*\u001a\u00020\u00072\u0006\u0010&\u001a\u00020.J*\u0010/\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0082\b\u00a2\u0006\u0002\u0010\u0019J\u000e\u00100\u001a\u00020#2\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007H\u0002J,\u00105\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\u0017\u00106\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u001407\u00a2\u0006\u0002\b8\u00a2\u0006\u0002\u00109R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lio/bazel/kotlin/builder/toolchain/CompilationTaskContext;", "", "info", "Lio/bazel/kotlin/model/CompilationTaskInfo;", "out", "Ljava/io/PrintStream;", "executionRoot", "", "(Lio/bazel/kotlin/model/CompilationTaskInfo;Ljava/io/PrintStream;Ljava/lang/String;)V", "getInfo", "()Lio/bazel/kotlin/model/CompilationTaskInfo;", "isTracing", "", "level", "", "start", "", "timings", "", "execute", "T", "name", "Lkotlin/Function0;", "task", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "executeCompilerTask", "", "args", "compile", "Lkotlin/Function2;", "", "printOnFail", "printOnSuccess", "finalize", "", "successful", "print", "msg", "printCompilerOutput", "lines", "printLines", "header", "prefix", "filterEmpty", "printProto", "Lcom/google/protobuf/MessageOrBuilder;", "pushTimedTask", "reportUnhandledException", "throwable", "", "trimExecutionRootPrefix", "toPrint", "whenTracing", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "src_main_kotlin_io_bazel_kotlin_builder_toolchain-toolchain"})
public final class CompilationTaskContext {
    @NotNull
    private final CompilationTaskInfo info;
    @NotNull
    private final PrintStream out;
    @NotNull
    private final String executionRoot;
    private final long start;
    @Nullable
    private List<String> timings;
    private int level;
    private final boolean isTracing;

    public CompilationTaskContext(@NotNull CompilationTaskInfo info, @NotNull PrintStream out2, @NotNull String executionRoot) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(out2, "out");
        Intrinsics.checkNotNullParameter(executionRoot, "executionRoot");
        this.info = info;
        this.out = out2;
        this.executionRoot = executionRoot;
        this.start = System.currentTimeMillis();
        this.level = -1;
        ProtocolStringList protocolStringList = this.info.getDebugList();
        Intrinsics.checkNotNullExpressionValue(protocolStringList, "info.debugList");
        Set debugging = CollectionsKt.toSet(protocolStringList);
        this.timings = debugging.contains("timings") ? (List)new ArrayList() : null;
        this.isTracing = debugging.contains("trace");
    }

    public /* synthetic */ CompilationTaskContext(CompilationTaskInfo compilationTaskInfo, PrintStream printStream, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = FileSystems.getDefault().getPath("", new String[0]).toAbsolutePath() + File.separator;
        }
        this(compilationTaskInfo, printStream, string);
    }

    @NotNull
    public final CompilationTaskInfo getInfo() {
        return this.info;
    }

    public final void reportUnhandledException(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        throwable.printStackTrace(this.out);
    }

    public final void print(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.out.println(msg);
    }

    public final void printLines(@NotNull String header, @NotNull List<String> lines, @NotNull String prefix, boolean filterEmpty) {
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        if (!(((CharSequence)header).length() > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.out.println(StringsKt.endsWith$default(header, ":", false, 2, null) ? header : header + ':');
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!(((CharSequence)it).length() > 0) && filterEmpty) continue;
            this.out.println(prefix + it);
        }
        this.out.println();
    }

    public static /* synthetic */ void printLines$default(CompilationTaskContext compilationTaskContext, String string, List list, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "|  ";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        compilationTaskContext.printLines(string, list, string2, bl);
    }

    @Nullable
    public final <T> T whenTracing(@NotNull Function1<? super CompilationTaskContext, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        return this.isTracing ? (T)block.invoke(this) : null;
    }

    public final void printProto(@NotNull String header, @NotNull MessageOrBuilder msg) {
        Intrinsics.checkNotNullParameter(header, "header");
        Intrinsics.checkNotNullParameter(msg, "msg");
        String string = TextFormat.printToString(msg);
        Intrinsics.checkNotNullExpressionValue(string, "printToString(msg)");
        String[] stringArray = new String[]{"\n"};
        CompilationTaskContext.printLines$default(this, header, StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null), null, true, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void printCompilerOutput(@NotNull List<String> lines) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(lines, "lines");
        Iterable $this$map$iv = lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.trimExecutionRootPrefix((String)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        PrintStream printStream = this.out;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            printStream.println(p0);
        }
    }

    private final String trimExecutionRootPrefix(String toPrint) {
        return StringsKt.startsWith$default(toPrint, this.executionRoot, false, 2, null) ? StringsKt.replaceFirst$default(toPrint, this.executionRoot, "", false, 4, null) : toPrint;
    }

    @NotNull
    public final List<String> executeCompilerTask(@NotNull List<String> args2, @NotNull Function2<? super String[], ? super PrintStream, Integer> compile2, boolean printOnFail, boolean printOnSuccess) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(compile2, "compile");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(outputStream);
        Collection $this$toTypedArray$iv = args2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        int result = ((Number)compile2.invoke((String[])thisCollection$iv.toArray(new String[0]), ps)).intValue();
        InputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        List<String> output = TextStreamsKt.readLines(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n));
        if (result != 0) {
            if (printOnFail) {
                this.printCompilerOutput(output);
                throw new CompilationStatusException("compile phase failed", result, null, 4, null);
            }
            throw new CompilationStatusException("compile phase failed", result, output);
        }
        if (printOnSuccess) {
            this.printCompilerOutput(output);
        }
        return output;
    }

    public static /* synthetic */ List executeCompilerTask$default(CompilationTaskContext compilationTaskContext, List list, Function2 function2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return compilationTaskContext.executeCompilerTask(list, function2, bl, bl2);
    }

    public final <T> T execute(@NotNull String name, @NotNull Function0<? extends T> task) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(task, "task");
        return this.execute(new Function0<String>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$name;
            }
        }, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <T> T execute(@NotNull Function0<String> name, @NotNull Function0<? extends T> task) {
        T t2;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(task, "task");
        if (this.timings == null) {
            t2 = task.invoke();
        } else {
            T t3;
            void this_$iv;
            CompilationTaskContext compilationTaskContext = this;
            String name$iv = name.invoke();
            boolean $i$f$pushTimedTask = false;
            ++this_$iv.level;
            List<String> previousTimings$iv = this_$iv.timings;
            this_$iv.timings = new ArrayList();
            try {
                T t4;
                long start$iv = System.currentTimeMillis();
                boolean bl = false;
                T it$iv = t4 = task.invoke();
                boolean bl2 = false;
                long stop$iv = System.currentTimeMillis();
                List<String> list = previousTimings$iv;
                Intrinsics.checkNotNull(list);
                ((Collection)list).add(StringsKt.repeat("  ", this_$iv.level) + " * " + name$iv + ": " + (stop$iv - start$iv) + " ms");
                List<String> list2 = this_$iv.timings;
                Intrinsics.checkNotNull(list2);
                previousTimings$iv.addAll((Collection<String>)list2);
                t3 = t4;
            }
            finally {
                --this_$iv.level;
                this_$iv.timings = previousTimings$iv;
            }
            t2 = t3;
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T pushTimedTask(String name, Function0<? extends T> task) {
        T t2;
        boolean $i$f$pushTimedTask = false;
        ++this.level;
        List<String> previousTimings = this.timings;
        this.timings = new ArrayList();
        try {
            T t3;
            long start2 = System.currentTimeMillis();
            boolean bl = false;
            T it = t3 = task.invoke();
            boolean bl2 = false;
            long stop = System.currentTimeMillis();
            List<String> list = previousTimings;
            Intrinsics.checkNotNull(list);
            ((Collection)list).add(StringsKt.repeat("  ", this.level) + " * " + name + ": " + (stop - start2) + " ms");
            List<String> list2 = this.timings;
            Intrinsics.checkNotNull(list2);
            previousTimings.addAll((Collection<String>)list2);
            t2 = t3;
        }
        finally {
            InlineMarker.finallyStart(1);
            --this.level;
            this.timings = previousTimings;
            InlineMarker.finallyEnd(1);
        }
        return t2;
    }

    public final void finalize(boolean successful) {
        block1: {
            if (!successful) break block1;
            List<String> list = this.timings;
            if (list != null) {
                List<String> list2;
                List<String> it = list2 = list;
                boolean bl = false;
                CompilationTaskContext.printLines$default(this, "Task timings for " + this.info.getLabel() + " (total: " + (System.currentTimeMillis() - this.start) + " ms)", it, null, false, 12, null);
            }
        }
    }
}

