/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar.misplaced;

import java.io.IOException;
import org.objectweb.asm.ClassReader;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.JarProcessor;

public abstract class MisplacedClassProcessor
implements JarProcessor {
    public abstract void handleMisplacedClass(EntryStruct var1, String var2);

    public abstract boolean shouldTransform();

    public abstract boolean shouldKeep();

    @Override
    public boolean process(EntryStruct entryStruct) throws IOException {
        String string;
        if (!entryStruct.name.endsWith(".class")) {
            return true;
        }
        try {
            string = new ClassReader(entryStruct.data).getClassName() + ".class";
        }
        catch (Exception exception) {
            System.err.println("Unable to read classname from bytecode in " + entryStruct.name);
            System.err.println("Shading is therefore impossible, so this entry will be skipped.");
            System.err.println(exception.getClass().getName() + ": " + exception.getMessage());
            entryStruct.skipTransform = true;
            return true;
        }
        if (!string.equals(entryStruct.name)) {
            System.err.println(this.formatMisplacedClassMessage(entryStruct, string));
            this.handleMisplacedClass(entryStruct, string);
            if (!this.shouldTransform()) {
                entryStruct.skipTransform = true;
            }
            return this.shouldKeep();
        }
        return true;
    }

    protected String formatMisplacedClassMessage(EntryStruct entryStruct, String string) {
        return "Fully-qualified classname does not match jar entry:\n  jar entry: " + entryStruct.name + "\n  class name: " + string;
    }
}

