<div style="max-width: 700px; margin: 60px auto; font-family: system-ui, sans-serif;">

<svg height="48" width="48" viewBox="0 0 24 24" style="display: block; margin: 20px auto;" xmlns="http://www.w3.org/2000/svg"><path d="M4.709 15.955l4.72-2.647.08-.23-.08-.128H9.2l-.79-.048-2.698-.073-2.339-.097-2.266-.122-.571-.121L0 11.784l.055-.352.48-.321.686.06 1.52.103 2.278.158 1.652.097 2.449.255h.389l.055-.157-.134-.098-.103-.097-2.358-1.596-2.552-1.688-1.336-.972-.724-.491-.364-.462-.158-1.008.656-.722.881.06.225.061.893.686 1.908 1.476 2.491 1.833.365.304.145-.103.019-.073-.164-.274-1.355-2.446-1.446-2.49-.644-1.032-.17-.619a2.97 2.97 0 01-.104-.729L6.283.134 6.696 0l.996.134.42.364.62 1.414 1.002 2.229 1.555 3.03.456.898.243.832.091.255h.158V9.01l.128-1.706.237-2.095.23-2.695.08-.76.376-.91.747-.492.584.28.48.685-.067.444-.286 1.851-.559 2.903-.364 1.942h.212l.243-.242.985-1.306 1.652-2.064.73-.82.85-.904.547-.431h1.033l.76 1.129-.34 1.166-1.064 1.347-.881 1.142-1.264 1.7-.79 1.36.073.11.188-.02 2.856-.606 1.543-.28 1.841-.315.833.388.091.395-.328.807-1.969.486-2.309.462-3.439.813-.042.03.049.061 1.549.146.662.036h1.622l3.02.225.79.522.474.638-.079.485-1.215.62-1.64-.389-3.829-.91-1.312-.329h-.182v.11l1.093 1.068 2.006 1.81 2.509 2.33.127.578-.322.455-.34-.049-2.205-1.657-.851-.747-1.926-1.62h-.128v.17l.444.649 2.345 3.521.122 1.08-.17.353-.608.213-.668-.122-1.374-1.925-1.415-2.167-1.143-1.943-.14.08-.674 7.254-.316.37-.729.28-.607-.461-.322-.747.322-1.476.389-1.924.315-1.53.286-1.9.17-.632-.012-.042-.14.018-1.434 1.967-2.18 2.945-1.726 1.845-.414.164-.717-.37.067-.662.401-.589 2.388-3.036 1.44-1.882.93-1.086-.006-.158h-.055L4.132 18.56l-1.13.146-.487-.456.061-.746.231-.243 1.908-1.312-.006.006z" fill="#D97757" fill-rule="nonzero"/></svg>

## Getting Started with Claude Code in __IDE_NAME__

Claude Code seamlessly integrates with __IDE_NAME__ to enhance your coding workflow. This integration allows you
to leverage Claude's capabilities directly within your preferred development environment.

### Requirements

1. Install [Claude Code](https://docs.claude.com/en/docs/claude-code/overview)

```
npm install -g @anthropic-ai/claude-code
```

2. Run `claude` and login to your Claude account

### First Steps

To start using Claude Code with __IDE_NAME__:

1. If you are using your IDE's built-in terminal, simply run `claude` from the project root directory
2. If you are using an external terminal, run `claude` and use the `/ide` command to connect to an IDE

> Tip: Use the `⌘ + Esc` shortcut key to launch Claude Code directly from the project root directory

### Key Features

- <strong>Diff viewing</strong>: Open file diffs in the IDE diff viewer for reviewing and modifying proposed changes
- <strong>Selection context</strong>: The current selection in the IDE is automatically shared with Claude Code
- <strong>File reference shortcuts</strong>: Use `Cmd+Option+K` (Mac) or `Ctrl+Alt+K` (Linux/Windows) to insert file
  references (e.g., @File#L1-99)
- <strong>Diagnostics sharing</strong>: Squiggly errors and warnings are shared with Claude Code in real-time

### Next Steps

Try out some of these [common workflows](https://docs.staging.ant.dev/en/docs/claude-code/common-tasks)!

#### Understand unfamiliar code

```
> what does the payment processing system do?
> find where user permissions are checked
> explain how the caching layer works
```

#### Automate Git operations

```
> commit my changes
> create a pr
> which commit added tests for markdown back in December?
> rebase on main and resolve any merge conflicts
```

#### Edit code intelligently

```
> add input validation to the signup form
> refactor the logger to use the new API
> fix the race condition in the worker queue
```

#### Test and debug your code

```
> run tests for the auth module and fix failures
> find and fix security vulnerabilities
> explain why this test is failing
```

#### Encourage deeper thinking

For complex problems, explicitly ask Claude to think more deeply:

```
> think about how we should architect the new payment service
> think hard about the edge cases in our authentication flow
```

Claude Code will show an indicator when it is using extended thinking. You can proactively prompt Claude to "think" or "
think deeply" for more planning-intensive tasks. We suggest that you first tell Claude about your task and let it gather
context from your project. Then, ask it to "think" to create a plan.

### Troubleshooting

- Update to the latest version of Claude Code
- Update to the latest version of the plugin
- Check that the `claude` command is in your system path (`which claude`)
- Ensure you're running `claude` from the project root directory
- Try restarting your IDE

---

For the latest information and more troubleshooting tips, please see
the [official documentation](https://docs.claude.com/s/claude-code-ide-integrations).

<br/>

</div>