// rTorrent - BitTorrent client
// Copyright (C) 2005-2011, Jari Sundell
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// In addition, as a special exception, the copyright holders give
// permission to link the code of portions of this program with the
// OpenSSL library under certain conditions as described in each
// individual source file, and distribute linked combinations
// including the two.
//
// You must obey the GNU General Public License in all respects for
// all of the code used other than OpenSSL.  If you modify file(s)
// with this exception, you may extend this exception to your version
// of the file(s), but you are not obligated to do so.  If you do not
// wish to do so, delete this exception statement from your version.
// If you delete this exception statement from all source files in the
// program, then also delete it here.
//
// Contact:  Jari Sundell <jaris@ifi.uio.no>
//
//           Skomakerveien 33
//           3185 Skoppum, NORWAY

#ifndef RTORRENT_COMMAND_SCHEDULER_H
#define RTORRENT_COMMAND_SCHEDULER_H

#include <cstdint>
#include <vector>
#include <string>

namespace torrent {
class Object;
}

namespace rpc {

class CommandSchedulerItem;

class CommandScheduler : public std::vector<CommandSchedulerItem*> {
public:
  typedef std::function<void (const std::string&)> SlotString;
  typedef std::pair<int, int>                      Time;
  typedef std::vector<CommandSchedulerItem*>       base_type;

  using base_type::value_type;
  using base_type::begin;
  using base_type::end;

  CommandScheduler() {}
  ~CommandScheduler();

  void                set_slot_error_message(SlotString s) { m_slotErrorMessage = s; }

  // slot_error_message or something.

  iterator            find(const std::string& key);

  // If the key already exists then the old item is deleted. It is
  // safe to call erase on end().
  iterator            insert(const std::string& key);
  void                erase(iterator itr);
  void                erase_str(const std::string& key)                { erase(find(key)); }

  void                parse(const std::string& key, const std::string& bufAbsolute,
                            const std::string& bufInterval, const torrent::Object& command);

  static uint32_t     parse_absolute(const char* str);
  static uint32_t     parse_interval(const char* str);

  static Time         parse_time(const char* str);

private:
  void                call_item(value_type item);

  SlotString          m_slotErrorMessage;
};

}

#endif
