/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSearchReference;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedSearchOperation;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedSearchReference
extends InterceptedOperation
implements InMemoryInterceptedSearchReference {
    @NotNull
    private final ReadOnlySearchRequest searchRequest;
    @Nullable
    private SearchResultReference reference;

    InterceptedSearchReference(@NotNull InterceptedSearchOperation op, @NotNull SearchResultReferenceProtocolOp reference, Control ... requestControls) {
        super(op);
        this.searchRequest = op.getRequest();
        this.reference = reference.toSearchResultReference(requestControls);
    }

    @Override
    @NotNull
    public ReadOnlySearchRequest getRequest() {
        return this.searchRequest;
    }

    @Override
    @Nullable
    public SearchResultReference getSearchReference() {
        return this.reference;
    }

    @Override
    public void setSearchReference(@Nullable SearchResultReference reference) {
        this.reference = reference;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("InterceptedSearchReference(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.searchRequest);
        buffer.append(", reference=");
        buffer.append(this.reference);
        buffer.append(')');
    }
}

