/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.util.Locale;

public class ZipSlip {
    public static String safeZipEntryName(String name) {
        if (ZipSlip.isUnsafeZipEntryName(name)) {
            throw new IllegalArgumentException(String.format("'%s' is not a safe zip entry name.", name));
        }
        return name;
    }

    public static boolean isUnsafeZipEntryName(String name) {
        return name.isEmpty() || name.startsWith("/") || name.startsWith("\\") || ZipSlip.containsDirectoryNavigation(name) || name.contains(":") && ZipSlip.isWindows();
    }

    private static boolean containsDirectoryNavigation(String name) {
        if (!name.contains("..")) {
            return false;
        }
        return name.endsWith("\\..") || name.contains("..\\") || name.endsWith("/..") || name.contains("../");
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.US).contains("windows");
    }
}

