/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.OptionalItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.Orphan;

public abstract class SimpleNodePushElaborator
extends Elaborator {
    @Override
    public SequenceEvaluator eagerly() {
        ItemEvaluator itemEval = this.elaborateForItem();
        return new OptionalItemEvaluator(itemEval);
    }

    @Override
    public PullEvaluator elaborateForPull() {
        ItemEvaluator itemEval = this.elaborateForItem();
        return context -> SingletonIterator.makeIterator(itemEval.eval(context));
    }

    @Override
    public PushEvaluator elaborateForPush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ItemEvaluator elaborateForItem() {
        SimpleNodeConstructor instr = (SimpleNodeConstructor)this.getExpression();
        ItemEvaluator select = instr.getSelect().makeElaborator().elaborateForItem();
        short kind = (short)instr.getItemType().getPrimitiveType();
        Configuration config = this.getConfiguration();
        return context -> {
            UnicodeString content;
            Item contentItem = select.eval(context);
            if (contentItem == null) {
                content = EmptyUnicodeString.getInstance();
            } else {
                content = contentItem.getUnicodeStringValue();
                content = instr.checkContent(content, context);
            }
            Orphan o = new Orphan(config);
            o.setNodeKind(kind);
            o.setStringValue(content);
            o.setNodeName(instr.evaluateNodeName(context));
            return o;
        };
    }

    @Override
    public BooleanEvaluator elaborateForBoolean() {
        ItemEvaluator ie = this.elaborateForItem();
        return context -> ExpressionTool.effectiveBooleanValue(ie.eval(context));
    }

    @Override
    public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
        ItemEvaluator ie = this.elaborateForItem();
        return context -> {
            Item item = ie.eval(context);
            return item == null ? this.handleNullUnicodeString(zeroLengthWhenAbsent) : item.getUnicodeStringValue();
        };
    }
}

