SYD-MDWE(1)

# NAME

*syd-mdwe* - Run a program under Memory-Deny-Write-Execute protections

# SYNOPSIS

*syd-mdwe* _[-hms]_ _{command [args...]}_

# DESCRIPTION

*syd-mdwe* utility runs a program under Memory-Deny-Write-Execute (MDWE)
protections. The protections can be applied using _prctl_(2) and
_seccomp_(2), These protections are identical to what Syd applies by
default.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-m*
:< Enable MDWE protections using _prctl_(2) PR_SET_MDWE (default: both).
|[ *-s*
:< Enable MDWE protections using _seccomp_(2) (default: both).

# EXAMPLES

Running pax-test once standalone and once under _syd-mdwe_(1) on a 6.8
kernel we get the following differences:

[[ *PaX Testcase*
:- *standalone*
:- *mdwe*
|  Executable anonymous mapping
:- Killed
:- Killed
|  Executable bss
:- Killed
:- Killed
|  Executable data
:- Killed
:- Killed
|  Executable heap
:- Killed
:- Killed
|  Executable stack
:- Killed
:- Killed
|  Executable shared library bss
:- Killed
:- Killed
|  Executable shared library data
:- Killed
:- Killed
|  Executable anonymous mapping (mprotect)
:- Vulnerable
:- Killed
|  Executable bss (mprotect)
:- Vulnerable
:- Killed
|  Executable data (mprotect)
:- Vulnerable
:- Killed
|  Executable heap (mprotect)
:- Vulnerable
:- Killed
|  Executable stack (mprotect)
:- Vulnerable
:- Killed
|  Executable shared library bss (mprotect)
:- Vulnerable
:- Killed
|  Executable shared library data (mprotect):
:- Vulnerable
:- Killed
|  Writable text segments
:- Vulnerable
:- Killed

The test was performed with paxtest-0.9.15:

```
PaXtest - Copyright(c) 2003-2016 by Peter Busser <peter@adamantix.org> and Brad Spengler <spender@grsecurity.net>
Released under the GNU Public Licence version 2 or later

Mode: 1
Blackhat
Kernel: 
Linux syd 6.8.0-syd-13213-g70293240c5ce #9 SMP PREEMPT_DYNAMIC Mon Mar 25 04:40:47 CET 2024 x86_64 GNU/Linux
```

# EXIT STATUS

On clean exit, *syd-mdwe* exits with the same code as the child process.
On unclean termination, exit code is set to 128 plus signal number. In
case executing the child process fails *syd-mdwe* exits with the
_errno_(3) number.

# CAVEATS

This utility does not work on MIPS where Linux requires executable stack.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _syd-lock_(1), _syd-ofd_(1), _syd-pds_(1), _seccomp_(2), _prctl_(2), _PR_SET_MDWE_(2const)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
