/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.minidns.dnslabel.DnsLabel;
import org.minidns.record.Data;
import org.minidns.record.NSEC;
import org.minidns.record.Record;
import org.minidns.util.Base32;

public class NSEC3
extends Data {
    public static final byte FLAG_OPT_OUT = 1;
    private static final Map<Byte, HashAlgorithm> HASH_ALGORITHM_LUT = new HashMap<Byte, HashAlgorithm>();
    public final HashAlgorithm hashAlgorithm;
    public final byte hashAlgorithmByte;
    public final byte flags;
    public final int iterations;
    private final byte[] salt;
    private final byte[] nextHashed;
    private final byte[] typeBitmap;
    public final List<Record.TYPE> types;
    private String nextHashedBase32Cache;
    private DnsLabel nextHashedDnsLabelCache;

    public static NSEC3 parse(DataInputStream dis, int length) throws IOException {
        byte hashAlgorithm = dis.readByte();
        byte flags = dis.readByte();
        int iterations = dis.readUnsignedShort();
        int saltLength = dis.readUnsignedByte();
        byte[] salt = new byte[saltLength];
        if (dis.read(salt) != salt.length) {
            throw new IOException();
        }
        int hashLength = dis.readUnsignedByte();
        byte[] nextHashed = new byte[hashLength];
        if (dis.read(nextHashed) != nextHashed.length) {
            throw new IOException();
        }
        byte[] typeBitmap = new byte[length - (6 + saltLength + hashLength)];
        if (dis.read(typeBitmap) != typeBitmap.length) {
            throw new IOException();
        }
        List<Record.TYPE> types = NSEC.readTypeBitMap(typeBitmap);
        return new NSEC3(hashAlgorithm, flags, iterations, salt, nextHashed, types);
    }

    private NSEC3(HashAlgorithm hashAlgorithm, byte hashAlgorithmByte, byte flags, int iterations, byte[] salt, byte[] nextHashed, List<Record.TYPE> types) {
        assert (hashAlgorithmByte == (hashAlgorithm != null ? hashAlgorithm.value : hashAlgorithmByte));
        this.hashAlgorithmByte = hashAlgorithmByte;
        this.hashAlgorithm = hashAlgorithm != null ? hashAlgorithm : HashAlgorithm.forByte(hashAlgorithmByte);
        this.flags = flags;
        this.iterations = iterations;
        this.salt = salt;
        this.nextHashed = nextHashed;
        this.types = types;
        this.typeBitmap = NSEC.createTypeBitMap(types);
    }

    public NSEC3(byte hashAlgorithm, byte flags, int iterations, byte[] salt, byte[] nextHashed, List<Record.TYPE> types) {
        this(null, hashAlgorithm, flags, iterations, salt, nextHashed, types);
    }

    public NSEC3(byte hashAlgorithm, byte flags, int iterations, byte[] salt, byte[] nextHashed, Record.TYPE ... types) {
        this(null, hashAlgorithm, flags, iterations, salt, nextHashed, Arrays.asList(types));
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.NSEC3;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeByte(this.hashAlgorithmByte);
        dos.writeByte(this.flags);
        dos.writeShort(this.iterations);
        dos.writeByte(this.salt.length);
        dos.write(this.salt);
        dos.writeByte(this.nextHashed.length);
        dos.write(this.nextHashed);
        dos.write(this.typeBitmap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append((Object)this.hashAlgorithm).append(' ').append(this.flags).append(' ').append(this.iterations).append(' ').append(this.salt.length == 0 ? "-" : new BigInteger(1, this.salt).toString(16).toUpperCase(Locale.ROOT)).append(' ').append(Base32.encodeToString(this.nextHashed));
        for (Record.TYPE type : this.types) {
            sb.append(' ').append((Object)type);
        }
        return sb.toString();
    }

    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    public int getSaltLength() {
        return this.salt.length;
    }

    public byte[] getNextHashed() {
        return (byte[])this.nextHashed.clone();
    }

    public String getNextHashedBase32() {
        if (this.nextHashedBase32Cache == null) {
            this.nextHashedBase32Cache = Base32.encodeToString(this.nextHashed);
        }
        return this.nextHashedBase32Cache;
    }

    public DnsLabel getNextHashedDnsLabel() {
        if (this.nextHashedDnsLabelCache == null) {
            String nextHashedBase32 = this.getNextHashedBase32();
            this.nextHashedDnsLabelCache = DnsLabel.from(nextHashedBase32);
        }
        return this.nextHashedDnsLabelCache;
    }

    public void copySaltInto(byte[] dest, int destPos) {
        System.arraycopy(this.salt, 0, dest, destPos, this.salt.length);
    }

    public static enum HashAlgorithm {
        RESERVED(0, "Reserved"),
        SHA1(1, "SHA-1");

        public final byte value;
        public final String description;

        private HashAlgorithm(int value, String description) {
            if (value < 0 || value > 255) {
                throw new IllegalArgumentException();
            }
            this.value = (byte)value;
            this.description = description;
            HASH_ALGORITHM_LUT.put(this.value, this);
        }

        public static HashAlgorithm forByte(byte b) {
            return HASH_ALGORITHM_LUT.get(b);
        }
    }
}

