package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DbfsRecord invokes the dbfs.DbfsRecord API synchronously
func (client *Client) DbfsRecord(request *DbfsRecordRequest) (response *DbfsRecordResponse, err error) {
	response = CreateDbfsRecordResponse()
	err = client.DoAction(request, response)
	return
}

// DbfsRecordWithChan invokes the dbfs.DbfsRecord API asynchronously
func (client *Client) DbfsRecordWithChan(request *DbfsRecordRequest) (<-chan *DbfsRecordResponse, <-chan error) {
	responseChan := make(chan *DbfsRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DbfsRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DbfsRecordWithCallback invokes the dbfs.DbfsRecord API asynchronously
func (client *Client) DbfsRecordWithCallback(request *DbfsRecordRequest, callback func(response *DbfsRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DbfsRecordResponse
		var err error
		defer close(result)
		response, err = client.DbfsRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DbfsRecordRequest is the request struct for api DbfsRecord
type DbfsRecordRequest struct {
	*requests.RpcRequest
	Data       string           `position:"Query" name:"Data"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// DbfsRecordResponse is the response struct for api DbfsRecord
type DbfsRecordResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	PageNo    int64         `json:"PageNo" xml:"PageNo"`
	PageSize  int64         `json:"PageSize" xml:"PageSize"`
	Total     int64         `json:"Total" xml:"Total"`
	Records   []RecordsItem `json:"Records" xml:"Records"`
}

// CreateDbfsRecordRequest creates a request to invoke DbfsRecord API
func CreateDbfsRecordRequest() (request *DbfsRecordRequest) {
	request = &DbfsRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "DbfsRecord", "", "")
	request.Method = requests.POST
	return
}

// CreateDbfsRecordResponse creates a response to parse from DbfsRecord response
func CreateDbfsRecordResponse() (response *DbfsRecordResponse) {
	response = &DbfsRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
