package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecommendTemplates invokes the elasticsearch.RecommendTemplates API synchronously
func (client *Client) RecommendTemplates(request *RecommendTemplatesRequest) (response *RecommendTemplatesResponse, err error) {
	response = CreateRecommendTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// RecommendTemplatesWithChan invokes the elasticsearch.RecommendTemplates API asynchronously
func (client *Client) RecommendTemplatesWithChan(request *RecommendTemplatesRequest) (<-chan *RecommendTemplatesResponse, <-chan error) {
	responseChan := make(chan *RecommendTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecommendTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecommendTemplatesWithCallback invokes the elasticsearch.RecommendTemplates API asynchronously
func (client *Client) RecommendTemplatesWithCallback(request *RecommendTemplatesRequest, callback func(response *RecommendTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecommendTemplatesResponse
		var err error
		defer close(result)
		response, err = client.RecommendTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecommendTemplatesRequest is the request struct for api RecommendTemplates
type RecommendTemplatesRequest struct {
	*requests.RoaRequest
	InstanceId    string `position:"Path" name:"InstanceId"`
	UsageScenario string `position:"Query" name:"usageScenario"`
}

// RecommendTemplatesResponse is the response struct for api RecommendTemplates
type RecommendTemplatesResponse struct {
	*responses.BaseResponse
	RequestId string           `json:"RequestId" xml:"RequestId"`
	Result    []TemplateConfig `json:"Result" xml:"Result"`
}

// CreateRecommendTemplatesRequest creates a request to invoke RecommendTemplates API
func CreateRecommendTemplatesRequest() (request *RecommendTemplatesRequest) {
	request = &RecommendTemplatesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "RecommendTemplates", "/openapi/instances/[InstanceId]/recommended-templates", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateRecommendTemplatesResponse creates a response to parse from RecommendTemplates response
func CreateRecommendTemplatesResponse() (response *RecommendTemplatesResponse) {
	response = &RecommendTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
