package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FtParamList invokes the ft.FtParamList API synchronously
func (client *Client) FtParamList(request *FtParamListRequest) (response *FtParamListResponse, err error) {
	response = CreateFtParamListResponse()
	err = client.DoAction(request, response)
	return
}

// FtParamListWithChan invokes the ft.FtParamList API asynchronously
func (client *Client) FtParamListWithChan(request *FtParamListRequest) (<-chan *FtParamListResponse, <-chan error) {
	responseChan := make(chan *FtParamListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FtParamList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FtParamListWithCallback invokes the ft.FtParamList API asynchronously
func (client *Client) FtParamListWithCallback(request *FtParamListRequest, callback func(response *FtParamListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FtParamListResponse
		var err error
		defer close(result)
		response, err = client.FtParamList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FtParamListRequest is the request struct for api FtParamList
type FtParamListRequest struct {
	*requests.RpcRequest
	Disk *[]FtParamListDisk `position:"Query" name:"Disk"  type:"Repeated"`
	Name string             `position:"Query" name:"Name"`
}

// FtParamListDisk is a repeated param struct in FtParamListRequest
type FtParamListDisk struct {
	Size *[]string `name:"Size" type:"Repeated"`
	Type *[]string `name:"Type" type:"Repeated"`
}

// FtParamListResponse is the response struct for api FtParamList
type FtParamListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Name      string `json:"Name" xml:"Name"`
}

// CreateFtParamListRequest creates a request to invoke FtParamList API
func CreateFtParamListRequest() (request *FtParamListRequest) {
	request = &FtParamListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2018-07-13", "FtParamList", "", "")
	request.Method = requests.POST
	return
}

// CreateFtParamListResponse creates a response to parse from FtParamList response
func CreateFtParamListResponse() (response *FtParamListResponse) {
	response = &FtParamListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
