package imagerecog

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectFruits invokes the imagerecog.DetectFruits API synchronously
func (client *Client) DetectFruits(request *DetectFruitsRequest) (response *DetectFruitsResponse, err error) {
	response = CreateDetectFruitsResponse()
	err = client.DoAction(request, response)
	return
}

// DetectFruitsWithChan invokes the imagerecog.DetectFruits API asynchronously
func (client *Client) DetectFruitsWithChan(request *DetectFruitsRequest) (<-chan *DetectFruitsResponse, <-chan error) {
	responseChan := make(chan *DetectFruitsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectFruits(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectFruitsWithCallback invokes the imagerecog.DetectFruits API asynchronously
func (client *Client) DetectFruitsWithCallback(request *DetectFruitsRequest, callback func(response *DetectFruitsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectFruitsResponse
		var err error
		defer close(result)
		response, err = client.DetectFruits(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectFruitsRequest is the request struct for api DetectFruits
type DetectFruitsRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// DetectFruitsResponse is the response struct for api DetectFruits
type DetectFruitsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectFruitsRequest creates a request to invoke DetectFruits API
func CreateDetectFruitsRequest() (request *DetectFruitsRequest) {
	request = &DetectFruitsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imagerecog", "2019-09-30", "DetectFruits", "imagerecog", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectFruitsResponse creates a response to parse from DetectFruits response
func CreateDetectFruitsResponse() (response *DetectFruitsResponse) {
	response = &DetectFruitsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
