package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAppEnvironmentDetail invokes the retailcloud.DescribeAppEnvironmentDetail API synchronously
func (client *Client) DescribeAppEnvironmentDetail(request *DescribeAppEnvironmentDetailRequest) (response *DescribeAppEnvironmentDetailResponse, err error) {
	response = CreateDescribeAppEnvironmentDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppEnvironmentDetailWithChan invokes the retailcloud.DescribeAppEnvironmentDetail API asynchronously
func (client *Client) DescribeAppEnvironmentDetailWithChan(request *DescribeAppEnvironmentDetailRequest) (<-chan *DescribeAppEnvironmentDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeAppEnvironmentDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAppEnvironmentDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppEnvironmentDetailWithCallback invokes the retailcloud.DescribeAppEnvironmentDetail API asynchronously
func (client *Client) DescribeAppEnvironmentDetailWithCallback(request *DescribeAppEnvironmentDetailRequest, callback func(response *DescribeAppEnvironmentDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppEnvironmentDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeAppEnvironmentDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppEnvironmentDetailRequest is the request struct for api DescribeAppEnvironmentDetail
type DescribeAppEnvironmentDetailRequest struct {
	*requests.RpcRequest
	AppId requests.Integer `position:"Query" name:"AppId"`
	EnvId requests.Integer `position:"Query" name:"EnvId"`
}

// DescribeAppEnvironmentDetailResponse is the response struct for api DescribeAppEnvironmentDetail
type DescribeAppEnvironmentDetailResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeAppEnvironmentDetailRequest creates a request to invoke DescribeAppEnvironmentDetail API
func CreateDescribeAppEnvironmentDetailRequest() (request *DescribeAppEnvironmentDetailRequest) {
	request = &DescribeAppEnvironmentDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DescribeAppEnvironmentDetail", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeAppEnvironmentDetailResponse creates a response to parse from DescribeAppEnvironmentDetail response
func CreateDescribeAppEnvironmentDetailResponse() (response *DescribeAppEnvironmentDetailResponse) {
	response = &DescribeAppEnvironmentDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
