package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateApplication invokes the sae.CreateApplication API synchronously
func (client *Client) CreateApplication(request *CreateApplicationRequest) (response *CreateApplicationResponse, err error) {
	response = CreateCreateApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateApplicationWithChan invokes the sae.CreateApplication API asynchronously
func (client *Client) CreateApplicationWithChan(request *CreateApplicationRequest) (<-chan *CreateApplicationResponse, <-chan error) {
	responseChan := make(chan *CreateApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateApplicationWithCallback invokes the sae.CreateApplication API asynchronously
func (client *Client) CreateApplicationWithCallback(request *CreateApplicationRequest, callback func(response *CreateApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateApplicationResponse
		var err error
		defer close(result)
		response, err = client.CreateApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateApplicationRequest is the request struct for api CreateApplication
type CreateApplicationRequest struct {
	*requests.RoaRequest
	NasId                         string           `position:"Query" name:"NasId"`
	JarStartArgs                  string           `position:"Query" name:"JarStartArgs"`
	OssAkSecret                   string           `position:"Body" name:"OssAkSecret"`
	MountHost                     string           `position:"Query" name:"MountHost"`
	AutoConfig                    requests.Boolean `position:"Query" name:"AutoConfig"`
	Envs                          string           `position:"Query" name:"Envs"`
	PhpPECLExtensions             string           `position:"Body" name:"PhpPECLExtensions"`
	PhpArmsConfigLocation         string           `position:"Query" name:"PhpArmsConfigLocation"`
	CustomHostAlias               string           `position:"Query" name:"CustomHostAlias"`
	Deploy                        requests.Boolean `position:"Query" name:"Deploy"`
	JarStartOptions               string           `position:"Query" name:"JarStartOptions"`
	AppName                       string           `position:"Query" name:"AppName"`
	NamespaceId                   string           `position:"Query" name:"NamespaceId"`
	ConfigMapMountDesc            string           `position:"Body" name:"ConfigMapMountDesc"`
	OssMountDescs                 string           `position:"Body" name:"OssMountDescs"`
	PreStop                       string           `position:"Query" name:"PreStop"`
	Cpu                           requests.Integer `position:"Query" name:"Cpu"`
	VSwitchId                     string           `position:"Query" name:"VSwitchId"`
	PackageType                   string           `position:"Query" name:"PackageType"`
	PostStart                     string           `position:"Query" name:"PostStart"`
	PhpExtensions                 string           `position:"Body" name:"PhpExtensions"`
	AssociateEip                  requests.Boolean `position:"Body" name:"AssociateEip"`
	WebContainer                  string           `position:"Query" name:"WebContainer"`
	Memory                        requests.Integer `position:"Query" name:"Memory"`
	SlsConfigs                    string           `position:"Query" name:"SlsConfigs"`
	CommandArgs                   string           `position:"Query" name:"CommandArgs"`
	AcrAssumeRoleArn              string           `position:"Query" name:"AcrAssumeRoleArn"`
	Readiness                     string           `position:"Query" name:"Readiness"`
	Timezone                      string           `position:"Query" name:"Timezone"`
	OssAkId                       string           `position:"Body" name:"OssAkId"`
	Liveness                      string           `position:"Query" name:"Liveness"`
	SecurityGroupId               string           `position:"Query" name:"SecurityGroupId"`
	PackageVersion                string           `position:"Query" name:"PackageVersion"`
	TomcatConfig                  string           `position:"Query" name:"TomcatConfig"`
	WarStartOptions               string           `position:"Query" name:"WarStartOptions"`
	EdasContainerVersion          string           `position:"Query" name:"EdasContainerVersion"`
	PackageUrl                    string           `position:"Query" name:"PackageUrl"`
	TerminationGracePeriodSeconds requests.Integer `position:"Query" name:"TerminationGracePeriodSeconds"`
	PhpConfig                     string           `position:"Body" name:"PhpConfig"`
	Replicas                      requests.Integer `position:"Query" name:"Replicas"`
	Command                       string           `position:"Query" name:"Command"`
	MountDesc                     string           `position:"Query" name:"MountDesc"`
	Jdk                           string           `position:"Query" name:"Jdk"`
	AppDescription                string           `position:"Query" name:"AppDescription"`
	AcrInstanceId                 string           `position:"Body" name:"AcrInstanceId"`
	VpcId                         string           `position:"Query" name:"VpcId"`
	ImageUrl                      string           `position:"Query" name:"ImageUrl"`
	Php                           string           `position:"Body" name:"Php"`
	PhpConfigLocation             string           `position:"Query" name:"PhpConfigLocation"`
}

// CreateApplicationResponse is the response struct for api CreateApplication
type CreateApplicationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateApplicationRequest creates a request to invoke CreateApplication API
func CreateCreateApplicationRequest() (request *CreateApplicationRequest) {
	request = &CreateApplicationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "CreateApplication", "/pop/v1/sam/app/createApplication", "serverless", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateApplicationResponse creates a response to parse from CreateApplication response
func CreateCreateApplicationResponse() (response *CreateApplicationResponse) {
	response = &CreateApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
