package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsDomainConfigs invokes the vs.DescribeVsDomainConfigs API synchronously
func (client *Client) DescribeVsDomainConfigs(request *DescribeVsDomainConfigsRequest) (response *DescribeVsDomainConfigsResponse, err error) {
	response = CreateDescribeVsDomainConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsDomainConfigsWithChan invokes the vs.DescribeVsDomainConfigs API asynchronously
func (client *Client) DescribeVsDomainConfigsWithChan(request *DescribeVsDomainConfigsRequest) (<-chan *DescribeVsDomainConfigsResponse, <-chan error) {
	responseChan := make(chan *DescribeVsDomainConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsDomainConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsDomainConfigsWithCallback invokes the vs.DescribeVsDomainConfigs API asynchronously
func (client *Client) DescribeVsDomainConfigsWithCallback(request *DescribeVsDomainConfigsRequest, callback func(response *DescribeVsDomainConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsDomainConfigsResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsDomainConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsDomainConfigsRequest is the request struct for api DescribeVsDomainConfigs
type DescribeVsDomainConfigsRequest struct {
	*requests.RpcRequest
	FunctionNames string           `position:"Query" name:"FunctionNames"`
	ShowLog       string           `position:"Query" name:"ShowLog"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVsDomainConfigsResponse is the response struct for api DescribeVsDomainConfigs
type DescribeVsDomainConfigsResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	DomainConfigs []DomainConfig `json:"DomainConfigs" xml:"DomainConfigs"`
}

// CreateDescribeVsDomainConfigsRequest creates a request to invoke DescribeVsDomainConfigs API
func CreateDescribeVsDomainConfigsRequest() (request *DescribeVsDomainConfigsRequest) {
	request = &DescribeVsDomainConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsDomainConfigs", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVsDomainConfigsResponse creates a response to parse from DescribeVsDomainConfigs response
func CreateDescribeVsDomainConfigsResponse() (response *DescribeVsDomainConfigsResponse) {
	response = &DescribeVsDomainConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
