/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.lang.ref.WeakReference;
import java.net.URL;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.web.WebView;
import net.java.html.BrwsrCtx;
import org.netbeans.html.boot.fx.AbstractFXPresenter;

public final class InitializeWebView
extends AbstractFXPresenter
implements Runnable {
    private final WebView webView;
    private final Runnable myLoad;
    BrwsrCtx ctx;

    public InitializeWebView(WebView webView, Runnable onLoad) {
        this.webView = webView;
        this.myLoad = onLoad;
        webView.setUserData(this.reference());
    }

    @Override
    public void run() {
        this.ctx = BrwsrCtx.findDefault(InitializeWebView.class);
        if (this.myLoad != null) {
            this.myLoad.run();
        }
    }

    @Override
    void waitFinished() {
    }

    @Override
    WebView findView(URL resource) {
        Worker w = this.webView.getEngine().getLoadWorker();
        w.stateProperty().addListener((ChangeListener)new FindViewListener(this, resource, (Worker<Void>)w));
        return this.webView;
    }

    public final void runInContext(Runnable r) {
        this.ctx.execute(r);
    }

    private static class FindViewListener
    extends WeakReference<InitializeWebView>
    implements ChangeListener<Worker.State> {
        private InitializeWebView toNotify;
        private final URL resource;
        private final Worker<Void> w;
        private String previous;

        public FindViewListener(InitializeWebView view, URL resource, Worker<Void> w) {
            super(view);
            this.toNotify = view;
            this.resource = resource;
            this.w = w;
        }

        public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State newState) {
            InitializeWebView view = (InitializeWebView)this.get();
            if (view == null) {
                this.w.stateProperty().removeListener((ChangeListener)this);
                return;
            }
            if (newState.equals((Object)Worker.State.SUCCEEDED) && this.checkValid(view)) {
                view.onPageLoad();
                this.toNotify = null;
            }
            if (newState.equals((Object)Worker.State.FAILED)) {
                this.checkValid(view);
                throw new IllegalStateException("Failed to load " + this.resource);
            }
        }

        private boolean checkValid(InitializeWebView view) {
            String crnt = view.webView.getEngine().getLocation();
            if (this.previous != null && !this.previous.equals(crnt)) {
                this.w.stateProperty().removeListener((ChangeListener)this);
                return false;
            }
            this.previous = crnt;
            return true;
        }
    }
}

