/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPFILEDIRVIEW_H
#define KFTPFILEDIRVIEW_H

#include <qwidget.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qsplitter.h>

namespace KFTPSession {
  class Session;
  class Manager;
}

class KToolBar;
class KComboBox;
class KAction;
class KLineEdit;

namespace KFTPEngine {
  class Thread;
  class Event;
}

namespace KFTPWidgets {

namespace Browser {

class ListView;
class TreeView;
class Actions;
class FilterWidget;

/**
 * @author Jernej Kos
 */
class View : public QWidget
{
Q_OBJECT
friend class Actions;
friend class ListView;
friend class TreeView;
friend class KFTPSession::Manager;
friend class KFTPSession::Session;
public:
    View(QWidget *parent, const char *name, KFTPEngine::Thread *client, KFTPSession::Session *session);
    ~View();

    void init();
    void populateToolbar();
    void setTreeVisible(bool visible);

    TreeView *getTreeView() { return m_tree; }
    ListView *getListView() { return m_list; }

    void setCompanion(View *companion);
private:
    KFTPSession::Session *m_session;
    KFTPEngine::Thread *m_ftpClient; /* FTP Client */
    
    ListView *m_list; /* The list view */
    TreeView *m_tree; /* The tree view */
    Actions *m_actions;

    KToolBar *m_toolBarFirst;  /* Upper toolbar */
    KToolBar *m_toolBarSecond; /* Lower toolbar */
    KToolBar *m_searchToolBar;

    QLabel *m_statusMsg;
    QLabel *m_connDurationMsg;
    QPushButton *m_sslIcon;
    QSplitter *m_splitter;

    QTimer *m_connTimer;
    QTime m_connDuration;

    KComboBox *m_historyCombo;
    FilterWidget *m_searchFilter;
public slots:
    void updateActions();
    void updateBookmarks();
private slots:
    void slotHistoryEraseClicked();
    void slotHistoryActivated(const QString &text);
    void slotDisplayCertInfo();
    void slotDurationUpdate();

    void slotEngineEvent(KFTPEngine::Event *event);

    void slotConfigUpdate();
};

}

}

#endif
