

#include <qstring.h>
#include <qvaluevector.h>

#include "qcut.h"

QCut::QCut()
{
}

QCut::~QCut()
{
}

QString QCut::cut( QString sep1, QString sep2, QString cutString, int field1, int field2, bool show1, bool show2 )
{
  if ( cutString.isEmpty() )
    return cutString;

  // position variables
  QValueVector<int> pos1 (cutString.length());
  QValueVector<int> pos2 (cutString.length());

   // how often was the field found ?
  int i1=0;
  int i2=0;

  pos1[i1]=-1;
  pos2[i2]=-1;

  // sep1, sep2

  int i = 0;
  // if the string is empty
  if ( ! sep1.isEmpty() )
  {
    // as long as the first separator is found
    do
    {
      i1+=1;
      i = cutString.find( sep1, pos1[i1-1]+1 );

      // as long as the next character from current position is sep1
      while( cutString.mid( i+1, 1 ) == sep1 && i >= 0 )
        i++;
      pos1[i1] = i;
    }
    while( pos1[i1] >= 0 );
    i1--;
  }

  // if the string is empty
  if ( ! sep2.isEmpty() )
  {
    // as long as the second separator is found
    do
    {
      i2+=1;
      i = cutString.find(sep2,pos2[i2-1]+1);

      // as long as the next character from current position is sep1
      while( cutString.mid( i+1, 1 ) == sep2 && i >= 0)
        i++;
      pos2[i2] = i;
    }
    while(pos2[i2] >= 0);
    i2--;
  }

  // 0 -> first field - begin at the beginning
  if ( field1 == 0 )
  {
     pos1[field1] = 0;
  }

  // less than 0 -> begin position from the right
  if ( field1 < 0 )
  {
       field1 = i1 + field1 + 1;
  }

  // pos1 larger than available hits
  if ( field1 > i1 )
  {
     return cutString;
  }

  // 0 -> last field - end at the last position
  if ( field2 == 0 )
  {
     pos2[0] = cutString.length();
  }

  // less than 0 -> begin position from the right
  if ( field2 < 0 )
  {
       field2 = i2 + field2 + 1;
  }

  // pos2 larger than available hits
  if ( field2 > i2 )
  {
     return cutString;
  }

  // position of the begin is behind the position of the end
  if ( pos1[field1] > pos2[field2] )
  {
    int tmp = pos1[field1];
    pos1[field1] = pos2[field2];
    pos2[field2] = tmp;
  }

   // don't show seperator sep1
  if ( pos1[field1] < pos2[field2] && show1 == false )
  {
     pos1[field1]+=sep1.length();
  }

   // don't show seperator sep2
  if ( pos1[field1] > pos2[field2] && show2 == false )
  {
     pos2[field2]+=sep2.length();
  }

  // cut string and return it
  return cutString.mid( pos1[field1], pos2[field2]-pos1[field1] );

}

