/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _DIALOGBOOKEDITOR_H
#define _DIALOGBOOKEDITOR_H

#include <gtkmm.h>
#include <iostream>
#include <libintl.h>
#include "Book.h"
#include "DialogCalendar.h"

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)

using namespace std;


class DialogBookEditor : public Gtk::Window {
public:
  DialogBookEditor(Book* book);
  virtual ~DialogBookEditor();
  
  /* Emitted when the "Cancel" button has been clicked. */
  SigC::Signal2<void, DialogBookEditor*, Book*> signal_button_cancel_clicked;
  /* Emitted when the "Save" button has been clicked. */
  SigC::Signal2<void, DialogBookEditor*, Book*> signal_button_save_clicked;
  
  /* Returns a pointer to the book associated with this window. */
  Book* get_book(void);
  
protected:
  /* Called, whenever the "Title" field has changed. */
  void on_entry_title_changed(void);
  /* Called, whenever the readdate button has been clicked. */
  void on_button_readdate_clicked(void);
  /* Called, whenever the readdate in the calendar has been changed. */
  void on_calendar_readdate_selected(void);
  /* Called, whenever the readdate in the calendar has been doubleclicked. */
  void on_calendar_readdate_doubleclicked(void);
  /* Called, whenever the "Cancel" button has been clicked. */
  void on_button_cancel_clicked(void);
  /* Called, whenever the "Save" button has been clicked. */
  void on_button_save_clicked(void);
  /* Called, when the window was closed using the window manager. */
  bool on_window_delete_event(GdkEventAny* trash);
  /* Called, whenever some part of the window requires a redraw. */
  bool on_window_expose_event(GdkEventExpose* trash);
  
  Book*                  book;
  DialogCalendar         calendar;
  sigc::connection       calendar_signal_selected;
  Gtk::Table             table;
  
  // Entry boxes
  Gtk::Label             label_author;
  Gtk::Entry             entry_author;
  Gtk::Label             label_title;
  Gtk::Entry             entry_title;
  Gtk::Label             label_isbn;
  Gtk::Entry             entry_isbn;
  Gtk::Label             label_category;
  Gtk::ComboBoxEntryText combo_category;
  Gtk::Label             label_rating;
  Gtk::ComboBoxText      combo_rating;
  
  // Read date
  Gtk::Label             label_readdate;
  Gtk::HBox              hbox_readdate;
  Gtk::Entry             entry_readdate;
  Gtk::Button            button_readdate;
  Gtk::Image             image_readdate;
  
  // Summary
  Gtk::Label             label_summary;
  Gtk::TextView          text_summary;
  Gtk::ScrolledWindow    scroll_summary;
  
  // Review
  Gtk::Label             label_review;
  Gtk::TextView          text_review;
  Gtk::ScrolledWindow    scroll_review;
  Gtk::HBox              buttonbox;
  Gtk::Fixed             fixed;
  Gtk::Button            button_cancel;
  Gtk::Button            button_save;
};

#endif /* _DIALOGBOOKEDITOR_H */
