/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.ual.eawt;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.AppReopenedEvent;
import java.awt.desktop.AppReopenedListener;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.PrintFilesEvent;
import java.awt.desktop.PrintFilesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.desktop.SystemEventListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class OldApplicationAdapter {
    private static OldApplicationAdapter instance = null;
    private final Application application;
    private AboutHandler aboutHandler = null;
    private OpenFilesHandler openFilesHandler = null;
    private PreferencesHandler preferencesHandler = null;
    private PrintFilesHandler printFilesHandler = null;
    private QuitHandler quitHandler = null;
    private final List<AppReopenedListener> reopenListeners;
    private final ApplicationListener applicationListener = new ApplicationListener(){

        public void handleAbout(ApplicationEvent applicationEvent) {
            if (OldApplicationAdapter.this.aboutHandler != null) {
                OldApplicationAdapter.this.aboutHandler.handleAbout(new AboutEvent());
                applicationEvent.setHandled(true);
            }
        }

        public void handleOpenApplication(ApplicationEvent applicationEvent) {
        }

        public void handleOpenFile(ApplicationEvent applicationEvent) {
            if (OldApplicationAdapter.this.openFilesHandler != null) {
                List<File> list = Arrays.asList(new File(applicationEvent.getFilename()));
                OldApplicationAdapter.this.openFilesHandler.openFiles(new OpenFilesEvent(list, null));
                applicationEvent.setHandled(true);
            }
        }

        public void handlePreferences(ApplicationEvent applicationEvent) {
            if (OldApplicationAdapter.this.preferencesHandler != null) {
                OldApplicationAdapter.this.preferencesHandler.handlePreferences(new PreferencesEvent());
                applicationEvent.setHandled(true);
            }
        }

        public void handlePrintFile(ApplicationEvent applicationEvent) {
            if (OldApplicationAdapter.this.printFilesHandler != null) {
                List<File> list = Arrays.asList(new File(applicationEvent.getFilename()));
                OldApplicationAdapter.this.printFilesHandler.printFiles(new PrintFilesEvent(list));
                applicationEvent.setHandled(true);
            }
        }

        public void handleQuit(ApplicationEvent applicationEvent) {
            if (OldApplicationAdapter.this.quitHandler != null) {
                OldApplicationAdapter.this.quitHandler.handleQuitRequestWith(new QuitEvent(), new QuitResponse(){

                    public void performQuit() {
                        System.exit(0);
                    }

                    public void cancelQuit() {
                    }
                });
                applicationEvent.setHandled(false);
            }
        }

        public void handleReOpenApplication(ApplicationEvent applicationEvent) {
            for (AppReopenedListener appReopenedListener : OldApplicationAdapter.this.reopenListeners) {
                appReopenedListener.appReopened(new AppReopenedEvent());
            }
        }
    };

    public static OldApplicationAdapter getInstance() {
        if (instance == null) {
            instance = new OldApplicationAdapter();
        }
        return instance;
    }

    private OldApplicationAdapter() {
        this.application = Application.getApplication();
        this.reopenListeners = new ArrayList<AppReopenedListener>();
        this.application.addApplicationListener(this.applicationListener);
    }

    public void addAppEventListener(SystemEventListener systemEventListener) {
        if (!(systemEventListener instanceof AppReopenedListener)) {
            throw new UnsupportedOperationException("OldApplicationAdapter.addAppEventListener only supports AppReopenedListeners");
        }
        this.reopenListeners.add((AppReopenedListener)systemEventListener);
    }

    public void removeAppEventListener(SystemEventListener systemEventListener) {
        this.reopenListeners.remove(systemEventListener);
    }

    public void setAboutHandler(AboutHandler aboutHandler) {
        this.application.setEnabledAboutMenu(aboutHandler != null);
        this.aboutHandler = aboutHandler;
    }

    public void setOpenFileHandler(OpenFilesHandler openFilesHandler) {
        this.openFilesHandler = openFilesHandler;
    }

    public void setPreferencesHandler(PreferencesHandler preferencesHandler) {
        this.application.setEnabledPreferencesMenu(preferencesHandler != null);
        this.preferencesHandler = preferencesHandler;
    }

    public void setPrintFileHandler(PrintFilesHandler printFilesHandler) {
        this.printFilesHandler = printFilesHandler;
    }

    public void setQuitHandler(QuitHandler quitHandler) {
        this.quitHandler = quitHandler;
    }
}

