#!/usr/bin/env python

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# RetroClockScreenlet (c) 2007 bu Helder Fraga aka Whise



import screenlets
from screenlets import DefaultMenuItem
from screenlets.options import BoolOption, IntOption, ColorOption
import cairo
import gtk
import gobject
import commands
import sys
import os
import webkit
from screenlets import sensors

class FlipClockScreenlet (screenlets.Screenlet):
	"""Brings Web applications to your desktop"""
	
	# default meta-info for Screenlets
	__name__		= 'FlipClockScreenlet'
	__version__		= '0.2.1+'
	__requires__	= ['python-webkit']
	__author__		= 'Helder Fraga aka Whise'
	__desc__		= __doc__

	mypath = sys.argv[0][:sys.argv[0].find('FlipClockScreenlet.py')].strip()

	def __init__ (self, **keyword_args):
		# init stuff
		screenlets.Screenlet.__init__(
			self, 
			width=389, 
			height=128, 
			uses_theme=True, 
			is_widget=True, 
			is_sticky=True,
			draw_buttons=True, 
			**keyword_args)

		self.view = webkit.WebView()
		self.win = gtk.Window(gtk.WINDOW_TOPLEVEL)
		self.scr = self.win.get_screen()
		self.rgba = gtk.gdk.Screen.get_rgba_colormap(self.scr)
		gtk.widget_set_default_colormap(self.rgba)
		self.view.set_transparent(True)
		self.win.set_decorated(False)
		try:	# Workaround for Ubuntu Natty+
			self.win.set_property('has-resize-grip', False)
		except TypeError:
			pass
		self.win.add(self.view)

		self.url = "file://" + self.get_screenlet_dir() + "/Source/index.html"
		self.view.load_uri(self.url)
		self.win.connect('destroy', self.quitall)
		self.win.connect('configure-event', self.configure)
		self.view.connect('notify::title', self.update)

				
	def configure (self, widget, event):
		if event.x != self.x:
			self.x = event.x
			
		if event.y != self.y:
			self.y = event.y

		if event.width != self.width:
			self.width = event.width

		if event.height != self.height:
			self.height = event.height
			
	def on_init(self):
		self.win.set_default_size(389, 128)
		self.win.move(self.x,self.y)
		self.win.add_events(gtk.gdk.BUTTON_PRESS_MASK)
		self.win.connect('button-press-event', self.clicked)
		self.win.set_skip_taskbar_hint(True)
		self.win.set_skip_pager_hint(True)
		self.win.show_all()

	def clicked(self, widget, event):
		self.win.begin_move_drag(event.button, int(event.x_root), int(event.y_root), event.time)

	def update(self, widget):
		title = self.view.get_title()
		self.win.set_title(title)

	def quitall(self,widget):
		if len(self.session.instances) > 1:
			self.session.delete_instance (self.id)
			# notify about being removed (does this get send???)
			self.service.instance_removed(self.id)
		else:			
			self.session.quit_instance (self.id)
			self.service.instance_removed(self.id)


if __name__ == "__main__":
	import screenlets.session
	screenlets.session.create_session(FlipClockScreenlet)

