#!/usr/bin/env python

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import screenlets
from screenlets.options import ColorOption , BoolOption, FontOption
from screenlets import DefaultMenuItem , sensors
import pango
import gobject
import gtk
import cairo
import gconf
import time
import random
#use gettext for translation
import gettext

_ = screenlets.utils.get_translator(__file__)

def tdoc(obj):
	obj.__doc__ = _(obj.__doc__)
	return obj

@tdoc
class PongClockScreenlet (screenlets.Screenlet):
	"""Not yet another boring clock."""
	
	__name__	= 'PongClock'
	__version__	= '1.4.1+++'
	__author__	= 'Maurizio Garbarino'
	__desc__	= __doc__
	
	def __init__ (self, **keyword_args):
		"""Constructor"""
		#call super 
		screenlets.Screenlet.__init__(self, width=320 , height=200, 
			uses_theme=True,ask_on_option_override=False, **keyword_args)
		
		#initialiting stuff
		self.state="start"
		self.theme_name = "default"

		self.previousH = int(sensors.cal_get_hour24())
		self.previousM = int(sensors.cal_get_minute())	
		
		#add the update timer
		self.update()
		self.timer = gobject.timeout_add(50, self.update)
	
	def on_init (self):
		# Create the "basic" pop-up menu that should be displayed when right-clicked
		self.add_default_menuitems()

	def update (self):
		"""Called every 50 milliseconds to redraw the clock."""
		h = int(sensors.cal_get_hour24())
		m = int(sensors.cal_get_minute())	

		if not m==self.previousM:
			self.state="change minute"
			self.previousM=m

		if not h==self.previousH:
			self.state="change hour"
			self.previousH=h;


		if self.state=="start":
			self.p1y=120
			self.p2y=120
			self.ballX=(self.width/2)+4
			self.ballY=140

			self.ballDeltaX=8
			self.ballDeltaY=random.randrange(1,7)

			time.sleep(2)
			self.redraw_canvas()
			self.state="play"

		elif self.state=="play":
			#Player 1
			if self.ballDeltaX<0:
				err=(self.ballY-20-self.p1y)
				if abs(err)>3:
					if self.ballX<self.width/3:				
						if abs(err)>7:
							if err>0:err= 7
							else:    err=-7
					elif self.ballX<self.width/2:
						if abs(err)>7:
							if err>0:err= 4
							else:    err=-4
					elif self.ballX<self.width/4*3:
						if abs(err)>2:
							if err>0:err= 3
							else:    err=-3
					else: err=0 
			
				self.p1y+=err

			#Player 2
			if self.ballDeltaX>0:
				err=(self.ballY-20-self.p2y)
				if abs(err)>3:
					if self.ballX>self.width/3*2:				
						if abs(err)>7:
							if err>0:err= 7
							else:    err=-7
					elif self.ballX>self.width/2:
						if abs(err)>7:
							if err>0:err= 4
							else:    err=-4
					elif self.ballX>self.width/4:
						if abs(err)>2:
							if err>0:err= 3
							else:    err=-3 
					else: err=0 

				self.p2y+=err
	
			#Time
			h = int(sensors.cal_get_hour24())
			m = int(sensors.cal_get_minute())	
			self.time = sensors.cal_get_hour24() + sensors.cal_get_minute()

			#Ball
			self.ballX+=self.ballDeltaX
			self.ballY+=self.ballDeltaY
		
			if self.ballX+self.ballDeltaX>self.width-15: self.ballDeltaX=-self.ballDeltaX
			if self.ballY+self.ballDeltaY>self.height-15 : self.ballDeltaY=-self.ballDeltaY
		
			if self.ballX+self.ballDeltaX<10:self.ballDeltaX=-self.ballDeltaX
			if self.ballY+self.ballDeltaY<10:self.ballDeltaY=-self.ballDeltaY
		elif self.state=="change minute":
			#Player 1
			if self.ballDeltaX<0:
				if self.ballDeltaY>0:
					err=4
				else:
					err=-4
				self.p1y+=err

			#Player 2
			if self.ballDeltaX>0:
				err=(self.ballY-20-self.p2y)
				if abs(err)>3:
					if self.ballX>self.width/3*2:				
						if abs(err)>7:
							if err>0:err= 7
							else:    err=-7
					elif self.ballX>self.width/2:
						if abs(err)>7:
							if err>0:err= 4
							else:    err=-4
					elif self.ballX>self.width/4:
						if abs(err)>2:
							if err>0:err= 3
							else:    err=-3 
					else: err=0 

				self.p2y+=err
	
			#Ball
			self.ballX+=self.ballDeltaX
			self.ballY+=self.ballDeltaY
		
			if self.ballX+self.ballDeltaX>self.width-15:	self.ballDeltaX=-self.ballDeltaX
			if self.ballX+self.ballDeltaX<0:self.state="start"

		elif self.state=="change hour":
			#Player 1
			if self.ballDeltaX<0:
				err=(self.ballY-20-self.p1y)
				if abs(err)>3:
					if self.ballX<self.width/3:				
						if abs(err)>7:
							if err>0:err= 7
							else:    err=-7
					elif self.ballX<self.width/2:
						if abs(err)>7:
							if err>0:err= 4
							else:    err=-4
					elif self.ballX<self.width/4*3:
						if abs(err)>2:
							if err>0:err= 3
							else:    err=-3
					else: err=0 
			
				self.p1y+=err

			#Player 2
			if self.ballDeltaX<0:
				if self.ballDeltaY>0:
					err=4
				else:
					err=-4
				self.p2y+=err
	
			#Ball
			self.ballX+=self.ballDeltaX
			self.ballY+=self.ballDeltaY
		
			if self.ballX+self.ballDeltaX>self.width:	self.state="start"
			if self.ballX+self.ballDeltaX<0:self.ballDeltaX=-self.ballDeltaX



		if self.ballY+self.ballDeltaY>self.height-15 : self.ballDeltaY=-self.ballDeltaY		
		if self.ballY+self.ballDeltaY<10:self.ballDeltaY=-self.ballDeltaY
		
		if self.p1y<12: self.p1y=12
		if self.p2y<12: self.p2y=12

		if self.p1y>self.height-52: self.p1y=self.height-52
		if self.p2y>self.height-52: self.p2y=self.height-52

		self.redraw_canvas()
		return True # keep on running this event
	
	def on_draw (self, ctx):
		"""Draw the screenlet."""
		ctx.scale(self.scale, self.scale)
		
		# Background
		ctx.set_source_rgba(0,0,0,1) #Black
		self.draw_rectangle(ctx,  0,  0,  self.width,  self.height,  fill=True)		
		
		ctx.set_source_rgba(1,1,1,1) #White
		self.draw_rectangle(ctx,  0,  0,  self.width,  10,  fill=True)		
		self.draw_rectangle(ctx,  0,  self.height-10,  self.width,  10,  fill=True)		
		self.draw_rectangle(ctx,  (self.width/2)-1,  0,  3,  self.height,  fill=True)		
		
		ctx.set_source_rgba(1,1,1,1) #White
		#Player 1
		self.draw_rectangle(ctx,  2,  self.p1y,  8,  40,  fill=True)		

		#Player 2
		self.draw_rectangle(ctx,  self.width-10,  self.p2y,  8,  40,  fill=True)	
	
		#Time
		ctx.save()
		ctx.translate(self.width/2-95,20)

		if self.time[0] != "0":
			self.theme.render(ctx,self.time[0])
		ctx.translate(40,0)
		self.theme.render(ctx,self.time[1])
		ctx.translate(80,0)
		if self.time[2] != "0":
			self.theme.render(ctx,self.time[2])
			ctx.translate(40,0)
		self.theme.render(ctx,self.time[3])
		ctx.restore()

		#Ball
		self.draw_rectangle(ctx,  self.ballX,  self.ballY,  5,  5,  fill=True)	

	def on_draw_shape(self, ctx):
		self.draw_rectangle(ctx,  0,  0,  self.width*self.scale,  self.height*self.scale,  fill=True)		


# If the program is run directly or passed as an argument to the python
# interpreter then create a Screenlet instance and show it
if __name__ == "__main__":
	# create new session
	import screenlets.session
	screenlets.session.create_session(PongClockScreenlet)

















