// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2021 Konrad Twardowski

// A label widget with both icon and text

#pragma once

#include <QHBoxLayout>
#include <QLabel>
#include <QStyle>

class ULabel final: public QFrame {
public:
	explicit ULabel(QWidget *parent = nullptr);
	QLabel *iconLabel() { return m_iconLabel; }
	QLabel *textLabel() { return m_textLabel; }
	QHBoxLayout *labelLayout();
	void setIcon(const QIcon &value, const int size);
	void setIcon(const QString &iconName, const int size);
	void setIcon(const QStyle::StandardPixmap standardIcon, const int size);
	void setText(const QString &value);
	void setMarginAndSpacing(const int margin, const int spacing);
private:
	Q_DISABLE_COPY(ULabel)
	QLabel *m_iconLabel;
	QLabel *m_textLabel;
};
