# Contents

The directory 'scripts' contains the files:

* README.md
* process_dcache_output.sh
* default_gnp.inc
* single_plot.gnp
* multi_plot.gnp

and the directory 'sample_data'.


# Examples

Executing the following commands:
```
gnuplot single_plot.gnp
gnuplot multi_plot.gnp
```
will produce PDF files (single_plot.pdf and multi_plot.pdf)
with graphs showing the data in the directory 'sample_data'.


# Data Post-processing

To use these gnuplot programs with data generated by the cache benchmarks of
CAT (cat_collect -dcr, and cat_collect -dcw), the user must post-process the
output files of the benchmarks.
Executing the bash script 'process_dcache_output.sh' using as input a data file
generated by the data cache benchmarks will compute basic statistics
(min, avg, max) of the data gathered by each thread for each test size. The output
is automatically stored in a new file with the keyword '.stat' appended to its name.
These ".stat" files can be used as input for the gnuplot scripts.


# Modifying the Gnuplot scripts

The example scripts 'single_plot.gnp' and 'multi_plot.gnp' contain variables
(at the top of each script) that must be modified to fit the user's use case and
environment.

* The variables 'L1_per_core', 'L2_per_core', and 'L3_per_core' must be set to
  indicate the sizes of the caches per core

* The variables 'SML_STRIDE', 'BIG_STRIDE', 'SML_PPB', and 'BIG_PPB' must be set
  to the corresponding values reported in the benchmark output file.

* The directory 'DIR' where the user data resides, the name of the event 'EVENT' whose
  data is being plotted, and the plot title 'PLOT_TITLE'.
