# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventhub.aio import EventHubManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventHubManagementSchemaRegistryOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventHubManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_schema_registry_list_by_namespace(self, resource_group):
        response = self.client.schema_registry.list_by_namespace(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2022-01-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_schema_registry_create_or_update(self, resource_group):
        response = await self.client.schema_registry.create_or_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            schema_group_name="str",
            parameters={
                "createdAtUtc": "2020-02-20 00:00:00",
                "eTag": "str",
                "groupProperties": {"str": "str"},
                "id": "str",
                "location": "str",
                "name": "str",
                "schemaCompatibility": "str",
                "schemaType": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "updatedAtUtc": "2020-02-20 00:00:00",
            },
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_schema_registry_delete(self, resource_group):
        response = await self.client.schema_registry.delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            schema_group_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_schema_registry_get(self, resource_group):
        response = await self.client.schema_registry.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            schema_group_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...
