% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters.R
\name{clock-setters}
\alias{clock-setters}
\alias{set_year}
\alias{set_quarter}
\alias{set_month}
\alias{set_week}
\alias{set_day}
\alias{set_hour}
\alias{set_minute}
\alias{set_second}
\alias{set_millisecond}
\alias{set_microsecond}
\alias{set_nanosecond}
\alias{set_index}
\title{Calendar setters}
\usage{
set_year(x, value, ...)

set_quarter(x, value, ...)

set_month(x, value, ...)

set_week(x, value, ...)

set_day(x, value, ...)

set_hour(x, value, ...)

set_minute(x, value, ...)

set_second(x, value, ...)

set_millisecond(x, value, ...)

set_microsecond(x, value, ...)

set_nanosecond(x, value, ...)

set_index(x, value, ...)
}
\arguments{
\item{x}{\verb{[object]}

An object to set the component for.}

\item{value}{\verb{[integer]}

The value to set the component to.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} with the component set.
}
\description{
This family of functions sets fields in a calendar vector. Each
calendar has its own set of supported setters, which are documented on
their own help page:
\itemize{
\item \link[=year-month-day-setters]{year-month-day}
\item \link[=year-month-weekday-setters]{year-month-weekday}
\item \link[=year-week-day-setters]{year-week-day}
\item \link[=iso-year-week-day-setters]{iso-year-week-day}
\item \link[=year-quarter-day-setters]{year-quarter-day}
\item \link[=year-day-setters]{year-day}
}

There are also convenience methods for setting certain components
directly on R's native date and date-time types.
\itemize{
\item \link[=Date-setters]{dates (Date)}
\item \link[=posixt-setters]{date-times (POSIXct / POSIXlt)}
}

Some general rules about setting components on calendar types:
\itemize{
\item You can only set components that are relevant to the calendar type that
you are working with. For example, you can't set the quarter of a
year-month-day type. You'd have to convert to year-quarter-day first.
\item You can set a component that is at the current precision, or one level
of precision more precise than the current precision. For example,
you can set the day field of a month precision year-month-day type,
but not the hour field.
\item Setting a component can result in an \emph{invalid date}, such as
\code{set_day(year_month_day(2019, 02), 31)}, as long as it is eventually
resolved either manually or with a strategy from \code{\link[=invalid_resolve]{invalid_resolve()}}.
\item With sub-second precisions, you can only set the component corresponding
to the precision that you are at. For example, you can set the nanoseconds
of the second while at nanosecond precision, but not milliseconds.
}
}
\details{
You cannot set components directly on a time point type, such as
sys-time or naive-time. Convert it to a calendar type first. Similarly,
a zoned-time must be converted to either a sys-time or naive-time, and
then to a calendar type, to be able to set components on it.
}
\examples{
x <- year_month_day(2019, 1:3)

# Set the day
set_day(x, 12:14)

# Set to the "last" day of the month
set_day(x, "last")
}
