use core:debug;

class CtorClass {

	Int a;
	Dbg b;

	init() {
		init() {
			a = 20;
			b(30);
		}
	}

	init(Dbg d) {
		init() {
			a = 20;
			b = d;
		}
	}

	init(Int a) {
		init() {
			a = a;
			b(a * 2);
		}
	}

}


Int ctorTest() {
	CtorClass c;
	c.a + c.b.get;
}

Int ctorTest(Int v) {
	CtorClass c(v);
	c.a + c.b.get;
}

Int ctorTestDbg(Int v) {
	Dbg dbg(v);
	CtorClass c(dbg);
	if (same(dbg, c.b)) {
		c.a + c.b.get;
	} else {
		0;
	}
}

void ignoreCtor() {
	CtorClass(10);
}

class CtorBase {

	Int base;

	init(Int v) {
		init() { base = v; }
	}

	Int value() {
		base;
	}

}

class CtorDerived extends CtorBase {

	Int der;

	init(Int a, Int b) {
		init(a) { der = b; }
		// comments here should work!
	}

	init(Int a) {
		init(1) { der = 1; }
		// This is broken, it should not compile.
		this = CtorDerived(a, a);
	}

	Int value() {
		super:value + der;
	}

	Int brokenValue() {
		// This should not even compile!
		this = CtorDerived(1, 2);
		base + der;
	}

}


Int ctorDerTest(Int v) {
	CtorDerived z(v, v * 2);
	z.value;
}

Int ctorErrorTest() {
	CtorDerived z(4);
	z.value;
}

Int memberAssignErrorTest() {
	CtorDerived z(3, 4);
	z.brokenValue;
}


class DefCtorClass {
	CtorClass a;
	Dbg b;

	Int sum() {
		b.get + a.a + a.b.get;
	}
}

Int testDefaultCtor() {
	DefCtorClass d;
	// Default ctor should create all objects.
	d.sum;
}


class ImplicitInitClass {
	CtorClass a;

	init() {
		// 'init' will be called implicitly for us!
	}

	Int sum() {
		a.a + a.b.get;
	}
}

Int testImplicitInit() {
	ImplicitInitClass d;
	d.sum;
}
