/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2023 Dridi Boukelmoune <dridi.boukelmoune@gmail.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer
 *    in this position and unchanged.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Varnish Turbo Encabulator
 *
 * Align and print fields in a line-based output. Fields are delimited
 * with a horizontal tab HT and lines starting with a space SP are kept
 * verbatim. Lines are delimited with a single new line LF character. A
 * field starting with a vertical tab VT is justified to the left.
 *
 * Using non-ASCII or non-printable ASCII characters besides delimiters
 * and modifiers for fields and lines is undefined behavior.
 */

struct vte;

typedef int VTE_format_f(void *priv, const char *fmt, ...) v_printflike_(2, 3);

struct vte *VTE_new(int maxfields, int width);
int VTE_putc(struct vte *, char);
int VTE_cat(struct vte *, const char *);
int VTE_printf(struct vte *, const char *, ...) v_printflike_(2, 3);
int VTE_finish(struct vte *);
int VTE_format(const struct vte *, VTE_format_f *func, void *priv);
int VTE_dump(const struct vte *, VTE_format_f *func, void *priv);
void VTE_destroy(struct vte **);
