/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtcp;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.transform.node.outgoing.OutgoingSsrcStats;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsTracker;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtcp.RtcpSrPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/nlj/rtcp/RtcpSrUpdater;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "statsTracker", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;", "<init>", "(Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;)V", "getStatsTracker", "()Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "trace", "", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class RtcpSrUpdater
extends TransformerNode {
    @NotNull
    private final OutgoingStatisticsTracker statsTracker;

    public RtcpSrUpdater(@NotNull OutgoingStatisticsTracker statsTracker) {
        Intrinsics.checkNotNullParameter(statsTracker, "statsTracker");
        super("RtcpSrUpdater");
        this.statsTracker = statsTracker;
    }

    @NotNull
    public final OutgoingStatisticsTracker getStatsTracker() {
        return this.statsTracker;
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Packet packet = packetInfo.getPacket();
        RtcpSrPacket rtcpSrPacket = packet instanceof RtcpSrPacket ? (RtcpSrPacket)packet : null;
        if (rtcpSrPacket == null) {
            return packetInfo;
        }
        RtcpSrPacket rtcpSrPacket2 = rtcpSrPacket;
        OutgoingSsrcStats.Snapshot snapshot = this.statsTracker.getSsrcSnapshot(rtcpSrPacket2.getSenderSsrc());
        if (snapshot == null) {
            return null;
        }
        OutgoingSsrcStats.Snapshot ssrcStats = snapshot;
        rtcpSrPacket2.getSenderInfo().setSendersOctetCount(ssrcStats.getOctetCount());
        rtcpSrPacket2.getSenderInfo().setSendersPacketCount(ssrcStats.getPacketCount());
        return packetInfo;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

