/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.logging.Logger;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;

public class Occupant {
    private static final Logger LOGGER = Logger.getLogger(Occupant.class.getName());
    private final MUCAffiliation affiliation;
    private final MUCRole role;
    private final Jid jid;
    private final Resourcepart nick;

    Occupant(MUCItem item) {
        this.jid = item.getJid();
        this.affiliation = item.getAffiliation();
        this.role = item.getRole();
        this.nick = item.getNick();
    }

    Occupant(Presence presence) {
        MUCUser mucUser = (MUCUser)presence.getExtensionElement("x", "http://jabber.org/protocol/muc#user");
        MUCItem item = mucUser.getItem();
        this.jid = item.getJid();
        this.affiliation = item.getAffiliation();
        this.role = item.getRole();
        EntityFullJid from = presence.getFrom().asEntityFullJidIfPossible();
        if (from == null) {
            LOGGER.warning("Occupant presence without resource: " + presence.getFrom());
            this.nick = null;
        } else {
            this.nick = from.getResourcepart();
        }
    }

    public Jid getJid() {
        return this.jid;
    }

    public MUCAffiliation getAffiliation() {
        return this.affiliation;
    }

    public MUCRole getRole() {
        return this.role;
    }

    public Resourcepart getNick() {
        return this.nick;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Occupant)) {
            return false;
        }
        Occupant occupant = (Occupant)obj;
        return this.jid.equals(occupant.jid);
    }

    public int hashCode() {
        int result = this.affiliation.hashCode();
        result = 17 * result + this.role.hashCode();
        result = 17 * result + (this.jid != null ? this.jid.hashCode() : 0);
        result = 17 * result + (this.nick != null ? this.nick.hashCode() : 0);
        return result;
    }
}

