/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.filter;

import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.muc.packet.MUCUser;

public class MUCUserStatusCodeFilter
implements StanzaFilter {
    public static final MUCUserStatusCodeFilter STATUS_110_PRESENCE_TO_SELF = new MUCUserStatusCodeFilter(MUCUser.Status.PRESENCE_TO_SELF_110);
    private final MUCUser.Status status;

    public MUCUserStatusCodeFilter(MUCUser.Status status) {
        this.status = status;
    }

    public MUCUserStatusCodeFilter(int statusCode) {
        this(MUCUser.Status.create(statusCode));
    }

    @Override
    public boolean accept(Stanza stanza) {
        MUCUser mucUser = MUCUser.from(stanza);
        if (mucUser == null) {
            return false;
        }
        return mucUser.getStatus().contains(this.status);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": status=" + this.status;
    }
}

