/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.codecache.disk.adapters;

import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.gui.utils.codecache.disk.adapters.CodeAnnotationAdapter;
import jadx.gui.utils.codecache.disk.adapters.DataAdapter;
import jadx.gui.utils.codecache.disk.adapters.DataAdapterHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NodeDeclareRefAdapter
implements DataAdapter<NodeDeclareRef> {
    private final CodeAnnotationAdapter refAdapter;

    public NodeDeclareRefAdapter(CodeAnnotationAdapter refAdapter) {
        this.refAdapter = refAdapter;
    }

    @Override
    public void write(DataOutput out, NodeDeclareRef value) throws IOException {
        ICodeNodeRef node = value.getNode();
        if (node == null) {
            throw new RuntimeException("Null node in NodeDeclareRef");
        }
        this.refAdapter.write(out, (ICodeAnnotation)node);
        DataAdapterHelper.writeUVInt(out, value.getDefPos());
    }

    @Override
    public NodeDeclareRef read(DataInput in) throws IOException {
        ICodeNodeRef ref = (ICodeNodeRef)this.refAdapter.read(in);
        int defPos = DataAdapterHelper.readUVInt(in);
        NodeDeclareRef nodeDeclareRef = new NodeDeclareRef(ref);
        nodeDeclareRef.setDefPos(defPos);
        ref.setDefPosition(defPos);
        return nodeDeclareRef;
    }
}

