/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java;

import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.input.JadxInputPlugin;
import jadx.api.plugins.input.data.ILoadResult;
import jadx.api.plugins.input.data.impl.EmptyLoadResult;
import jadx.plugins.input.java.JavaClassReader;
import jadx.plugins.input.java.JavaInputLoader;
import jadx.plugins.input.java.JavaLoadResult;
import jadx.plugins.input.java.utils.JavaClassParseException;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class JavaInputPlugin
implements JadxInputPlugin {
    public static final JadxPluginInfo PLUGIN_INFO = new JadxPluginInfo("java-input", "JavaInput", "Load .class and .jar files");

    public JadxPluginInfo getPluginInfo() {
        return PLUGIN_INFO;
    }

    public ILoadResult loadFiles(List<Path> inputFiles) {
        return JavaInputPlugin.loadClassFiles(inputFiles, null);
    }

    public static ILoadResult loadClassFiles(List<Path> inputFiles, @Nullable Closeable closeable) {
        List<JavaClassReader> readers = new JavaInputLoader().collectFiles(inputFiles);
        if (readers.isEmpty()) {
            return EmptyLoadResult.INSTANCE;
        }
        return new JavaLoadResult(readers, closeable);
    }

    public static ILoadResult loadClassFiles(List<Path> inputFiles) {
        return JavaInputPlugin.loadClassFiles(inputFiles, null);
    }

    public static ILoadResult load(Function<JavaInputLoader, List<JavaClassReader>> loader) {
        return JavaInputPlugin.wrapClassReaders(loader.apply(new JavaInputLoader()));
    }

    public static ILoadResult loadFromInputStream(InputStream in, String fileName) {
        try {
            return JavaInputPlugin.wrapClassReaders(new JavaInputLoader().loadInputStream(in, fileName));
        }
        catch (Exception e) {
            throw new JavaClassParseException("Failed to read input stream", e);
        }
    }

    public static ILoadResult loadSingleClass(byte[] content, String fileName) {
        JavaClassReader reader = new JavaInputLoader().loadClass(content, fileName);
        return new JavaLoadResult(Collections.singletonList(reader));
    }

    public static ILoadResult wrapClassReaders(List<JavaClassReader> readers) {
        if (readers.isEmpty()) {
            return EmptyLoadResult.INSTANCE;
        }
        return new JavaLoadResult(readers);
    }
}

