/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.totp.user;

import java.security.SecureRandom;
import java.util.Random;

public class UserTOTPKey {
    private static final Random RANDOM = new SecureRandom();
    private final String username;
    private boolean confirmed;
    private byte[] secret;

    private static byte[] generateBytes(int length) {
        byte[] bytes = new byte[length];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    public UserTOTPKey(String username, int length) {
        this(username, UserTOTPKey.generateBytes(length), false);
    }

    public UserTOTPKey(String username, byte[] secret, boolean confirmed) {
        this.username = username;
        this.confirmed = confirmed;
        this.secret = secret;
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }
}

