/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.swt.CheckWrapped;
import java.util.ArrayList;
import java.util.List;

class CheckableWrapperList
extends TransformedList {
    private List wrappedSource = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckableWrapperList(EventList source) {
        super(source);
        source.getReadWriteLock().readLock().lock();
        try {
            this.prepareElements();
            source.addListEventListener(this);
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
    }

    public Object set(int index, Object value) {
        CheckWrapped checkWrapped = (CheckWrapped)value;
        return this.source.set(index, checkWrapped.getWrapped());
    }

    private void prepareElements() {
        for (int i = 0; i < this.source.size(); ++i) {
            CheckWrapped checkWrapped = new CheckWrapped(this.source.get(i));
            this.wrappedSource.add(i, checkWrapped);
        }
    }

    public Object get(int index) {
        return this.wrappedSource.get(index);
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.beginEvent();
        while (listChanges.next()) {
            CheckWrapped checkWrapped;
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                checkWrapped = new CheckWrapped(this.source.get(changeIndex));
                this.wrappedSource.add(changeIndex, checkWrapped);
            } else if (changeType == 1) {
                checkWrapped = (CheckWrapped)this.wrappedSource.get(changeIndex);
                checkWrapped.setWrapped(this.source.get(changeIndex));
            } else if (changeType == 0) {
                this.wrappedSource.remove(changeIndex);
            }
            this.updates.addChange(changeType, changeIndex);
        }
        this.updates.commitEvent();
    }
}

